% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/forceScheme.R
\name{forceScheme}
\alias{forceScheme}
\title{Force Scheme Projection}
\usage{
forceScheme(D, Y = NULL, max.iter = 50, tol = 0, fraction = 8,
  eps = 1e-05)
}
\arguments{
\item{D}{A dissimilarity structure such as that returned by dist or a full
symmetric matrix containing the dissimilarities.}

\item{Y}{Initial 2D configuration. A random configuration will be used when
omitted.}

\item{max.iter}{Maximum number of iterations that the algorithm will run.}

\item{tol}{The tolerance for the accumulated error between iterations. If set
to 0, the algorithm will run max.iter times.}

\item{fraction}{Controls the point movement. Larger values means less
freedom to move.}

\item{eps}{Minimum distance between two points.}
}
\value{
The 2D representation of the data.
}
\description{
Creates a 2D representation of the data based on a dissimilarity matrix. A few
modifications have been made in relation to the method described in the
literature: shuffled indices are used to minimize the order dependency
factor, only a fraction of delta is used for better stability and a tolerance
factor was introduced as a second stop criterion.
}
\examples{
# Eurodist example
emb <- forceScheme(eurodist)
plot(emb, type = "n", xlab ="", ylab ="", asp=1, axes=FALSE, main="")
text(emb, labels(eurodist), cex = 0.6)

# Iris example
emb <- forceScheme(dist(iris[,1:4]))
plot(emb, col=iris$Species)
}
\references{
Eduardo Tejada, Rosane Minghim, Luis Gustavo Nonato: On improved
  projection techniques to support visual exploration of multi-dimensional
  data sets. Information Visualization 2(4): 218-231 (2003)
}
\seealso{
\code{\link[stats]{dist}} (stats) and \code{\link[proxy]{dist}}
  (proxy) for d computation
}

