% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistical.R
\name{apply_column_spliceview}
\alias{apply_column_spliceview}
\alias{sapply_column_spliceview}
\title{Apply summary function to the columns in each segment of a SpliceView object}
\usage{
apply_column_spliceview(sv, FUN, simplify = FALSE, USE.NAMES = FALSE, ...)

sapply_column_spliceview(sv, FUN, simplify = TRUE, USE.NAMES = TRUE, ...)
}
\arguments{
\item{sv}{\code{SplicedView} object.}

\item{FUN}{function to apply.}

\item{simplify}{see \code{\link[=sapply]{sapply()}}.}

\item{USE.NAMES}{see \code{\link[=sapply]{sapply()}}.}

\item{...}{passed to FUN.}
}
\value{
see \code{\link[=sapply]{sapply()}}.
}
\description{
Apply summary function to each data point column in a SplicedView and return list of output data.
}
\examples{
r <- get_sample_recording()
d1 <- get_duration_annotation_data(r)
# only one relevant section for sample data
splicing_smile_df <- splice_time(d1, tier ='INTERACTION',
  comments = 'Mutual look and smile')

fv_list <- get_filtered_views(r, data_points = "Nose", n = 41, p = 3)
jv <- get_joined_view(fv_list)
sv_duration_smile <- get_spliced_view(jv, splicing_df = splicing_smile_df)
mean_mat <- apply_column_spliceview(sv_duration_smile, mean, na.rm=TRUE)
}
\seealso{
Other statistical and analysis functions: 
\code{\link{apply_segment_spliceview}()},
\code{\link{ave_cross_power_over_splices}()},
\code{\link{ave_cross_power_spliceview}()},
\code{\link{ave_power_over_splices}()},
\code{\link{ave_power_spliceview}()},
\code{\link{calculate_ave_cross_power1}()},
\code{\link{calculate_ave_power1}()},
\code{\link{compare_ave_cross_power1}()},
\code{\link{compare_ave_power1}()},
\code{\link{compare_avg_cross_power2}()},
\code{\link{compare_avg_power2}()},
\code{\link{difference_onsets}()},
\code{\link{pull_segment_spliceview}()},
\code{\link{sample_gap_splice}()},
\code{\link{sample_offset_splice}()},
\code{\link{summary_onsets}()},
\code{\link{visualise_sample_splices}()}
}
\concept{statistical and analysis functions}
