% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mosaicModel.R
\docType{package}
\name{mosaicModel}
\alias{mosaicModel}
\alias{mosaicModel-package}
\title{\code{mosaicModel} package}
\description{
Functions for teaching about modeling.
}
\details{
The package offers a handful of high-level functions for evaluating, displaying,
and interpreting models that work in a consistent way across model architectures, e.g.
lm, glm, rpart, randomForest, knn3, caret-train, and so on.
\itemize{
\item \code{mod_eval()} -- evaluate a model, that is, turn inputs into model values. For many model architectures, you can also get prediction or confidence intervals on the outputs.
\item \code{mod_plot()} -- produce a graphical display of the "shape" of a model. There can be as many as 4 input variables shown, along with the output.
\item \code{mod_effect()} -- calculate effect sizes, that is, how a change in an input variable changes the output
\item \code{mod_error()} -- find the mean square prediction error (or the log likelihood)
\item \code{mod_ensemble()} -- create an ensemble of bootstrap replications of the model, that is, models fit to resampled data from the original model.
\item \code{mod_cv()} -- carry out cross validation on one or more models.
\item \code{mod_fun()} -- extract a function from a model that implements the inputs-to-output relationship.
\code{mosaicModel} stays out of the business of training models. You do that using functions, e.g.
}
\itemize{
\item the familiar \code{lm} or \code{glm} provided by the \code{stats} package
\item \code{train} from the \code{caret} package for machine learning
\item \code{rpart}, \code{randomForest}, \code{rlm}, and other functions provided by other packages
}
}
