% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.survFit.R, R/predict_Nsurv.R,
%   R/predict_Nsurv_ode.R
\name{predict.survFit}
\alias{predict.survFit}
\alias{predict_Nsurv}
\alias{predict_Nsurv.survFit}
\alias{predict_Nsurv_ode}
\title{Predict method for \code{survFit} objects}
\usage{
\method{predict}{survFit}(
  object,
  data_predict = NULL,
  spaghetti = FALSE,
  mcmc_size = NULL,
  hb_value = TRUE,
  ratio_no.NA = 0.95,
  hb_valueFORCED = NA,
  extend_time = 100,
  ...
)

predict_Nsurv(object, ...)

\method{predict_Nsurv}{survFit}(
  object,
  data_predict = NULL,
  spaghetti = FALSE,
  mcmc_size = NULL,
  hb_value = TRUE,
  hb_valueFORCED = NA,
  extend_time = 100,
  ...
)

predict_Nsurv_ode(
  object,
  data_predict,
  spaghetti,
  mcmc_size,
  hb_value,
  hb_valueFORCED,
  extend_time,
  interpolate_length,
  interpolate_method,
  ...
)
}
\arguments{
\item{object}{An object of class \code{survFit}.}

\item{data_predict}{A dataframe with three columns \code{time}, \code{conc} and \code{replicate}
used for prediction. If \code{NULL}, prediction is based on \code{x} object of 
class \code{survFit} used for fitting.}

\item{spaghetti}{If \code{TRUE}, return a set of survival curves using
parameters drawn from the posterior distribution.}

\item{mcmc_size}{Can be used to reduce the number of mcmc samples in order to speed up
the computation. \code{mcmc_size} is the number of selected iterations for one chain. Default
is 1000. If all MCMC is wanted, set argument to \code{NULL}.}

\item{hb_value}{If \code{TRUE}, the background mortality \code{hb} is taken into account from the posterior.
If \code{FALSE}, parameter \code{hb} is set to 0. The default is \code{TRUE}.}

\item{ratio_no.NA}{A numeric between 0 and 1 standing for the proportion of non-NA values
required to compute quantile. The default is \eqn{0.95}.}

\item{hb_valueFORCED}{If \code{hb_value} is \code{FALSE}, it fix \code{hb}.}

\item{extend_time}{Length of time points interpolated with variable exposure profiles.}

\item{\dots}{Further arguments to be passed to generic methods}

\item{interpolate_length}{Length of the time sequence for which output is wanted.}

\item{interpolate_method}{The interpolation method for concentration. See package \code{deSolve} for details.
Default is \code{linear}.}
}
\value{
a \code{list} of \code{data.frame} with the quantiles of outputs in
\code{df_quantiles} or all the MCMC chaines \code{df_spaghetti}

an object of class \code{predict_Nsurv}.

The function returns an object of class \code{survFitPredict_Nsurv}, which is
a list with the two following \code{data.frame}:
\item{df_quantile}{A \code{data.frame} with 10 columns, \code{time}, \code{conc},
\code{replicate}, \code{Nsurv} (observed number of survivors)
 and other columns with median and 95\% credible interval
of the number of survivors computed with 2 different way 
refers as \code{check} and \code{valid}:  
\code{Nsurv_q50_check}, \code{Nsurv_qinf95_check},
\code{Nsurv_qsup95_check}, \code{Nsurv_q50_valid}, \code{Nsurv_qinf95_valid},
\code{Nsurv_qsup95_valid}. The \code{_check} refers to the number of survivors
at time \eqn{t} predicted using the observed number
of survivors at time \eqn{t-1},
while the \code{_valid} refers to the number of survivors predicted at time
\eqn{t} based on the predicted number of survivors at time \eqn{t-1}.}
\item{df_spaghetti}{NULL if arguement \code{spaghetti = FALSE}. With \code{spaghetti = TRUE}, it returns a
dataframe with all simulations based on MCMC parameters from a \code{survFit} object.}

an object of class \code{predict_Nsurv_ode}.
}
\description{
This is the generic \code{predict} S3 method for the \code{survFit} class.
It provides simulation for "SD" or "IT" models under constant or time-variable exposure.

It provides the simulated number of survivors for "SD" or "IT" models under
constant or time-variable exposure.

It provides the simulated number of survivors for "SD" or "IT" models under constant or
time-variable exposure.

This is a \code{method} to replace function \code{predict_Nsurv} used on \code{survFit}
object when computing issues happen. \code{predict_nsurv_ode} uses the \code{deSolve}
library to improve robustness. However, time to compute may be longer.
}
\examples{

# (1) Load the survival data
data("propiconazole_pulse_exposure")

# (2) Create an object of class "survData"
dataset <- survData(propiconazole_pulse_exposure)

\donttest{
# (3) Run the survFit function
out <- survFit(dataset , model_type = "SD")

# (4) Create a new data table for prediction
data_4prediction <- data.frame(time = 1:10,
                               conc = c(0,5,30,30,0,0,5,30,15,0),
                               replicate= rep("predict", 10))

# (5) Predict on a new dataset
predict_out <- predict(object = out, data_predict = data_4prediction, spaghetti = TRUE)

}



# (1) Load the survival data
data("propiconazole_pulse_exposure")

# (2) Create an object of class "survData"
dataset <- survData(propiconazole_pulse_exposure)

\donttest{
# (3) Run the survFit function
out <- survFit(dataset , model_type = "SD")

# (4) Create a new data table for prediction
data_4prediction <- data.frame(time = 1:10,
                               conc = c(0,5,30,30,0,0,5,30,15,0),
                               replicate= rep("predict", 10),
                               Nsurv = c(20,20,17,16,15,15,15,14,13,12))

# (5) Predict Nsurv on a new data set
predict_out <- predict_Nsurv(object = out, data_predict = data_4prediction, spaghetti = TRUE)

}


}
