% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimParams.R
\name{optimParams}
\alias{optimParams}
\title{optimParams}
\usage{
optimParams(X, Y, K, link = c("logit", "probit"), M = NULL, nc = 0)
}
\arguments{
\item{X}{Data matrix of covariables}

\item{Y}{Output as a binary vector}

\item{K}{Number of populations.}

\item{link}{The link type, 'logit' or 'probit'.}

\item{M}{the empirical cross-moments between X and Y (optional)}

\item{nc}{Number of cores (default: 0 to use all)}
}
\value{
An object 'op' of class OptimParams, initialized so that
  \code{op$run(theta0)} outputs the list of optimized parameters
  \itemize{
    \item p: proportions, size K
    \item beta: regression matrix, size dxK
    \item b: intercepts, size K
  }
  theta0 is a list containing the initial parameters. Only beta is required
  (p would be set to (1/K,...,1/K) and b to (0,...0)).
}
\description{
Wrapper function for OptimParams class
}
\examples{
# Optimize parameters from estimated mu
io <- generateSampleIO(100,
  1/2, matrix(c(1,-2,3,1),ncol=2), c(0,0), "logit")
mu <- computeMu(io$X, io$Y, list(K=2))
o <- optimParams(io$X, io$Y, 2, "logit")
\dontrun{
theta0 <- list(p=1/2, beta=mu, b=c(0,0))
par0 <- o$run(theta0)
# Compare with another starting point
theta1 <- list(p=1/2, beta=2*mu, b=c(0,0))
par1 <- o$run(theta1)
# Look at the function values at par0 and par1:
o$f( o$linArgs(par0) )
o$f( o$linArgs(par1) )}

}
\seealso{
\code{multiRun} to estimate statistics based on beta, and
  \code{generateSampleIO} for I/O random generation.
}
