% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marginal-effects.R
\name{marginal_effects}
\alias{marginal_effects}
\title{Marginal Effects for Modified Ordered Random Forests}
\usage{
marginal_effects(
  object,
  data = NULL,
  eval = "atmean",
  bandwitdh = 0.01,
  inference = FALSE
)
}
\arguments{
\item{object}{An \code{\link{morf}} object.}

\item{data}{Data set of class \code{data.frame} to estimate marginal effects. It must contain at least the same covariates used to train the forests. If \code{NULL}, marginal effects are estimated on \code{object$full_data}.}

\item{eval}{Evaluation point for marginal effects. Either \code{"mean"}, \code{"atmean"} or \code{"atmedian"}.}

\item{bandwitdh}{How many standard deviations \code{x_up} and \code{x_down} differ from \code{x}.}

\item{inference}{Whether to extract weights and compute standard errors. The weights extraction considerably slows down the program.}
}
\value{
Object of class \code{morf.marginal}.
}
\description{
Nonparametric estimation of marginal effects using an \code{\link{morf}} object.
}
\details{
\code{\link{marginal_effects}} can estimate mean marginal effects, marginal effects at the mean, or marginal effects at the
median, according to the \code{eval} argument.\cr 

The routine assumes that covariates with more than ten unique values are continuous. Otherwise, covariates are assumed to 
be discrete.\cr
}
\examples{
## Load data from orf package.
set.seed(1986)

library(orf)
data(odata)
odata <- odata[1:200, ] # Subset to reduce elapsed time.

y <- as.numeric(odata[, 1])
X <- as.matrix(odata[, -1])

## Fit morf . Use large number of trees.
forests <- morf(y, X, n.trees = 4000)

## Marginal effects at the mean.
me <- marginal_effects(forests, eval = "atmean")
print(me)
summary(me)

## LATEX.
print(me, latex = TRUE)

\donttest{
## Compute standard errors. This requires honest forests.
honest_forests <- morf(y, X, n.trees = 4000, honesty = TRUE)
honest_me <- marginal_effects(honest_forests, eval = "atmean", inference = TRUE)
honest_me$standard.errors
honest_me$p.values # These are not corrected for multiple hypotheses testing!

print(honest_me, latex = TRUE)}

}
\seealso{
\code{\link{morf}}
}
\author{
Riccardo Di Francesco
}
