plo_inter <- function(object,
                      var1,
                      var2,
                      excl1 = NULL,
                      excl2 = NULL,
                      comps = c(1,2),
                      shapesize = 1,
                      textsize = 3,
                      force = 1,
                      max.overlaps = Inf,
                      lines = TRUE,
                      dashes = TRUE) {

  # get coordinates of observations
  indiv <- pls::scores(object)
  class(indiv) <- "matrix"
  indiv <- as.data.frame(indiv)[, comps]
  names(indiv) <- paste0("axis", 1:2)

  # compute mean points of categories
  v12 <- interaction(var1, var2)
  coord <- stats::aggregate(indiv, list(v12), mean)
  names(coord)[1] <- "cat12"
  # coord$cat1 <- sub("\\..*", "", coord$cat12)
  # coord$cat2 <- sub(".*\\.", "", coord$cat12)
  levs1 <- rep(levels(var1), nlevels(var2))
  levs2 <- unlist(lapply(levels(var2), function(x) rep(x, nlevels(var1))))
  ok <- which(paste(levs1, levs2, sep = ".") %in% coord$cat12)
  coord$cat1 <- levs1[ok]
  coord$cat2 <- levs2[ok]

  # drop excluded categories
  coord <- coord[!(coord$cat1 %in% excl1 | coord$cat2 %in% excl2),]
  coord$cat1 <- factor(coord$cat1)
  coord$cat2 <- factor(coord$cat2)
  coord$cat12 <- factor(coord$cat12)

  # plot observations
  p <-
    ggplot2::ggplot(indiv, ggplot2::aes(x = .data$axis1, y = .data$axis2)) +
    ggplot2::geom_point(color = "gray95", size = 1) +
    ggplot2::geom_hline(yintercept = 0, colour = "gray", linetype = "solid", alpha = 0.6) +
    ggplot2::geom_vline(xintercept = 0, colour = "gray", linetype = "solid", alpha = 0.6) +
    ggplot2::xlab(paste("Comp", comps[1])) +
    ggplot2::ylab(paste("Comp", comps[2])) +
    ggplot2::theme_bw() +
    ggplot2::theme(panel.grid.major = ggplot2::element_blank(),
                   panel.grid.minor = ggplot2::element_blank())

  # add labels of categories
  p <- p +
    ggplot2::geom_point(data = coord,
                        ggplot2::aes(x = .data$axis1,
                                     y = .data$axis2,
                                     shape = .data$cat1,
                                     color = .data$cat1),
                        size = shapesize) +
    ggrepel::geom_text_repel(data = coord,
                             ggplot2::aes(x = .data$axis1,
                                          y = .data$axis2,
                                          label = .data$cat12,
                                          color = .data$cat1),
                             size = textsize,
                             force = force,
                             max.overlaps = max.overlaps) +
    ggplot2::guides(color = "none",
                    shape = "none")

  # add lines
  if(lines) p <- p +
    ggplot2::geom_path(data = coord,
                       ggplot2::aes(color = .data$cat1),
                       alpha = 0.3)

  # add dashes
  if(dashes) p <- p +
    ggplot2::geom_path(data = coord,
                       ggplot2::aes(group = .data$cat2),
                       color = "darkgray",
                       linetype = "dashed",
                       linewidth = 0.3,
                       alpha = 1)

  return(p)

}

# plo_inter(pls2,
#           var1 = pc18$catage,
#           var2 = pc18$diplome,
#           sel2 = 1:6,
#           dashes = T,
#           lines = T,
#           shapesize = 0)
