% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eaf.R
\name{eaf}
\alias{eaf}
\title{Exact computation of the EAF in 2D or 3D}
\usage{
eaf(x, sets, percentiles = NULL, maximise = FALSE, groups = NULL)
}
\arguments{
\item{x}{\code{matrix}|\code{data.frame}\cr Matrix or data frame of numerical
values, where each row gives the coordinates of a point. If \code{sets} is
missing, the last column of \code{x} gives the sets.}

\item{sets}{\code{integer()}\cr A vector that indicates the set of each point in \code{x}. If
missing, the last column of \code{x} is used instead.}

\item{percentiles}{\code{numeric()}\cr Vector indicating which percentiles are computed.
\code{NULL} computes all.}

\item{maximise}{\code{logical()}\cr Whether the objectives must be maximised
instead of minimised. Either a single logical value that applies to all
objectives or a vector of logical values, with one value per objective.}

\item{groups}{\code{factor()}\cr Indicates that the EAF must be computed separately for data
belonging to different groups.}
}
\value{
\code{data.frame()}\cr A data frame containing the exact representation of
EAF. The last column gives the percentile that corresponds to each
point. If groups is not \code{NULL}, then an additional column indicates to
which group the point belongs.
}
\description{
This function computes the EAF given a set of 2D or 3D points and a vector \code{set}
that indicates to which set each point belongs.
}
\note{
There are several examples of data sets in
\code{system.file(package="moocore","extdata")}.  The current implementation
only supports two and three dimensional points.
}
\examples{
extdata_path <- system.file(package="moocore", "extdata")

x <- read_datasets(file.path(extdata_path, "example1_dat"))
# Compute full EAF (sets is the last column)
str(eaf(x))

# Compute only best, median and worst
str(eaf(x[,1:2], sets = x[,3], percentiles = c(0, 50, 100)))

x <- read_datasets(file.path(extdata_path, "spherical-250-10-3d.txt"))
y <- read_datasets(file.path(extdata_path, "uniform-250-10-3d.txt"))
x <- rbind(data.frame(x, groups = "spherical"),
           data.frame(y, groups = "uniform"))
# Compute only median separately for each group
z <- eaf(x[,1:3], sets = x[,4], groups = x[,5], percentiles = 50)
str(z)
}
\references{
\insertRef{Grunert01}{moocore}

\insertRef{FonGueLopPaq2011emo}{moocore}
}
\seealso{
\code{\link[=read_datasets]{read_datasets()}}
}
\author{
Manuel \enc{López-Ibáñez}{Lopez-Ibanez}
}
\concept{eaf}
