% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classify.R
\name{monkeylearn_classify}
\alias{monkeylearn_classify}
\title{monkeylearn_classify}
\usage{
monkeylearn_classify(request, key = monkeylearn_key(quiet = TRUE),
  classifier_id = "cl_oFKL5wft", texts_per_req = 200, verbose = TRUE,
  params = NULL)
}
\arguments{
\item{request}{A vector of characters (each text smaller than 50kB)}

\item{key}{The API key}

\item{classifier_id}{The ID of the classifier}

\item{texts_per_req}{Number of texts to be fed through per request (max 200). Does not affect output, but may affect speed of processing.}

\item{verbose}{Whether to output messages about batch requests}

\item{params}{Parameters for the module as a named list. See the second example.}
}
\value{
A data.frame (tibble) with the results whose attribute is a data.frame (tibble) "headers" including the number of remaining queries as "x.query.limit.remaining".
Both data.frames include a column with the (list of) md5 checksum(s) of the corresponding text(s) computed using the \code{digest digest} function.
}
\description{
Access to Monkeylearn classifiers modules
}
\details{
Find IDs of classifiers using \url{https://app.monkeylearn.com/main/explore}.

You can use batch to send up to 200 texts to be analyzed within the API
(classification or extraction) with each request.
So for example, if you need to analyze 6000 tweets,
instead of doing 6000 requests to the API, you can use batch to send 30 requests,
each request with 200 tweets.
The function automatically makes these batch calls and waits if there is a throttle limit error,
but you might want to control the process yourself using several calls to the function.

You can check the number of calls you can still make in the API using \code{attr(output, "headers")$x.query.limit.remaining}
and \code{attr(output, "headers")$x.query.limit.limit}.
}
\examples{
\dontrun{
text1 <- "my dog is an avid rice eater"
text2 <- "i want to buy an iphone"
request <- c(text1, text2)
output <- monkeylearn_classify(request)
output
attr(output, "headers")}
}
