% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_documentations.R
\docType{data}
\name{protein_data}
\alias{protein_data}
\title{Protein data}
\format{
\describe{
  \item{group1}{ER+ data}
  \describe{
    \item{data}{raw data, protein in columns and samples in rows}
    \item{identifiers}{one column per identifier, rows in the same order as the protein order in
    'data', identifiers: RefSeq ID, gene name}
    }
  \item{group2}{ER- data}
  \describe{
    \item{data}{see above}
    \item{identifiers}{see above}
    }
}
}
\source{
Krug, Karsten et al. “Proteogenomic Landscape of Breast Cancer Tumorigenesis and Targeted
Therapy.” Cell vol. 183,5 (2020): 1436-1456.e31. doi:10.1016/j.cell.2020.10.036
}
\usage{
protein_data
}
\description{
Protein analysis of breast cancer patients data from Krug et al., 2020 (data from the Clinical
Proteomic Tumor Analysis Consortium (CPTAC)). The data is stratified by estrogen receptor (ER)
expression status (group1 = ER+, group2 = ER-). Each group is given as a sub-list containing
'data' (raw data, proteins in columns and samples in rows) and 'identifiers' (one column per
identifier, rows in the same order as the protein order in 'data').
}
\keyword{datasets}
