% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_reduction.R
\name{network_reduction_by_p_value}
\alias{network_reduction_by_p_value}
\title{Reduce the the entries in an adjacency matrix by thresholding on p-values}
\source{
\code{\link[WGCNA]{corPvalueStudent}}
}
\usage{
network_reduction_by_p_value(
  adjacency_matrix,
  number_of_samples,
  reduction_alpha = 0.05,
  p_value_adjustment_method = "BH",
  parallel_chunk_size = 10^6
)
}
\arguments{
\item{adjacency_matrix}{An adjacency matrix of correlation values.}

\item{number_of_samples}{The number of samples used to calculate the correlation matrix.}

\item{reduction_alpha}{A number indicating the alpha value applied for thresholding}

\item{p_value_adjustment_method}{A string of the correction method applied to p-values. Passed
to stats::p.adjust().}

\item{parallel_chunk_size}{Number of p-values in smallest work unit when computing in parallel.}
}
\value{
A reduced adjacency matrix with NA's at martix entries with p-values below threshold.
}
\description{
(INTERNAL) This function reduces an adjacency matrix of correlations. If computations are done
non-parallel \code{\link[WGCNA]{corPvalueStudent}} is used. If computations are done in
parallel, our own parallel implementation (\code{\link{corPvalueStudentParallel}}) of this
function is used.
function to calculate Student asymptotic p-values taking the number of samples into account.
P-values are adjusted using \link[stats]{p.adjust} function. The upper triangle without
diagonal entries
of the adjacency matrix is passed for faster computation. P-values can be adjusted using one
of several methods.
A significance threshold `alpha` can be set. All value entries below this threshold within the
initial adjacency matrix
will be set to NA. If a default cluster is registered with the `parallel` package the
computation will happen in
parallel automatically.
}
\examples{
adj_mat <- matrix(rnorm(36),nrow=6)
sum(is.na(adj_mat)) # before reduction
reduced_by_p_value_matrix <- network_reduction_by_p_value(adjacency_matrix=adj_mat,
                             number_of_samples=200, reduction_alpha = 0.05,
                             p_value_adjustment_method = "BH")
sum(is.na(reduced_by_p_value_matrix)) # after reduction
}
