% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline_functions.R
\name{make_layer}
\alias{make_layer}
\title{Creates individual molecular layers from raw data and unique identifiers}
\usage{
make_layer(
  name,
  data_group1,
  data_group2,
  identifier_group1,
  identifier_group2
)
}
\arguments{
\item{name}{Character string. Names the layer.}

\item{data_group1, data_group2}{Data frame containing raw molecular data of each group
(each stratum). Analyzed components (e.g., genes) in columns, samples (e.g. patients) in rows.}

\item{identifier_group1, identifier_group2}{Data frame containing component identifiers
(columns) of each component (rows) in the same order as the molecular data frame of each group.
 These identifiers are used to (a) interconnect graphs and (b) match drugs to drug targets.
 Must contain a column `type` which identifies the nature of the component (e.g., "protein")}
}
\value{
Named list containing the supplied data for each group (i.e., the dataset for one
layer), that can be supplied to \code{\link{start_pipeline}} and `name` giving the name of the
layer. Each sublist contains the `data` and the `identifiers`.
}
\description{
Helper function to transform input data to required pipeline input format. Additionally, the
supplied input is checked. Allows easy conversion of raw data into the structure accepted by
\code{\link{start_pipeline}}.
}
\examples{
data(mrna_data)

mrna_layer <- make_layer(name="mrna", data_group1=mrna_data$group1$data,
data_group2=mrna_data$group2$data,
identifier_group1=data.frame(gene_name=mrna_data$group1$identifiers),
identifier_group2=data.frame(gene_name=mrna_data$group2$identifiers))

}
