% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iss.R
\name{fetching_fully}
\alias{fetching_fully}
\title{A Decorator for Fetching All Available Data}
\usage{
fetching_fully(query_iss_fn)
}
\arguments{
\item{query_iss_fn}{A function object corresponding to \link{query_iss}.}
}
\value{
Decorated \code{query_iss_fn}.
}
\description{
A decorator for \link{query_iss} to increase the \code{start} parameter in a loop until
no more data is received.
}
\examples{
\dontrun{
fetching_fully(query_iss)(
    'engines/stock/markets/shares/boards/TQBR/securities/SBER/candles',
    params = list(
        from = URLencode('2020-01-10 10:00:00'),
        till = URLencode('2020-01-10 23:59:59'),
        interval = 1,
        start = 10
    )
)
}
}
