% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iss.R
\name{query_iss}
\alias{query_iss}
\title{Submit a REST Query to ISS}
\usage{
query_iss(
  rest_path,
  params = list(),
  iss_base_url = getOption("moexer.iss.base_url"),
  debug_output = getOption("moexer.debug"),
  follow_cursor = TRUE
)
}
\arguments{
\item{rest_path}{A REST path concatenated to \code{iss_base_url}.}

\item{params}{A HTTP GET query parameters string passed as a \code{list}.}

\item{iss_base_url}{The base ISS URL.}

\item{debug_output}{Print REST URLs as they are queried.}

\item{follow_cursor}{If \code{TRUE}, iterative queries will be issued to fetch all
section pages as indicated by \verb{<section>.cursor}; the cursor section
itself will be removed from the response.}
}
\value{
A list where every element is section as returned by ISS.  The
section content is parsed as a \code{tibble}.
}
\description{
See \url{http://iss.moex.com/iss/reference/} for the reference.
}
\examples{
\dontrun{
query_iss(
    rest_path = 'securities/SBER',
    params = list(iss.only = 'description'),
    debug_output = TRUE
)
}
}
