% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics_modsem_da.R,
%   R/generics_modsem_mplus.R, R/generics_modsem_pi.R
\name{summary.modsem_da}
\alias{summary.modsem_da}
\alias{summary.modsem_mplus}
\alias{summary.modsem_pi}
\title{summary for modsem objects}
\usage{
\method{summary}{modsem_da}(
  object,
  H0 = TRUE,
  verbose = TRUE,
  r.squared = TRUE,
  adjusted.stat = FALSE,
  digits = 3,
  scientific = FALSE,
  ci = FALSE,
  standardized = FALSE,
  loadings = TRUE,
  regressions = TRUE,
  covariances = TRUE,
  intercepts = TRUE,
  variances = TRUE,
  var.interaction = FALSE,
  ...
)

\method{summary}{modsem_mplus}(
  object,
  scientific = FALSE,
  standardize = FALSE,
  ci = FALSE,
  digits = 3,
  loadings = TRUE,
  regressions = TRUE,
  covariances = TRUE,
  intercepts = TRUE,
  variances = TRUE,
  ...
)

\method{summary}{modsem_pi}(object, ...)
}
\arguments{
\item{object}{modsem object to summarized}

\item{H0}{should a null model be estimated (used for comparison)}

\item{verbose}{print progress for the estimation of null model}

\item{r.squared}{calculate R-squared}

\item{adjusted.stat}{should sample size corrected/adjustes AIC and BIC be reported?}

\item{digits}{number of digits to print}

\item{scientific}{print p-values in scientific notation}

\item{ci}{print confidence intervals}

\item{standardized}{print standardized estimates}

\item{loadings}{print loadings}

\item{regressions}{print regressions}

\item{covariances}{print covariances}

\item{intercepts}{print intercepts}

\item{variances}{print variances}

\item{var.interaction}{if FALSE (default) variances for interaction terms will be removed (if present)}

\item{...}{arguments passed to lavaan::summary()}

\item{standardize}{standardize estimates}
}
\description{
summary for modsem objects

summary for modsem objects

summary for modsem objects
}
\examples{
\dontrun{
m1 <- "
 # Outer Model
 X =~ x1 + x2 + x3
 Y =~ y1 + y2 + y3
 Z =~ z1 + z2 + z3

 # Inner model
 Y ~ X + Z + X:Z
"

est1 <- modsem(m1, oneInt, "qml")
summary(est1, ci = TRUE, scientific = TRUE)
}
}
