% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modsem_pi.R
\name{get_pi_syntax}
\alias{get_pi_syntax}
\title{Get \code{lavaan} syntax for product indicator approaches}
\usage{
get_pi_syntax(model.syntax, method = "dblcent", match = FALSE, ...)
}
\arguments{
\item{model.syntax}{\code{lavaan} syntax}

\item{method}{method to use:
\code{"rca"} = residual centering approach,
\code{"uca"} = unconstrained approach,
\code{"dblcent"} = double centering approach,
\code{"pind"} = prod ind approach, with no constraints or centering,
\code{"custom"} = use parameters specified in the function call}

\item{match}{should the product indicators be created by using the match-strategy}

\item{...}{arguments passed to other functions (e.g., \link{modsem_pi})}
}
\value{
\code{character} vector
}
\description{
\code{get_pi_syntax()} is a function for creating the \code{lavaan} syntax used for estimating 
latent interaction models using one of the product indicators in \code{lavaan}.
}
\examples{
library(modsem)
library(lavaan)
m1 <- '
  # Outer Model
  X =~ x1 + x2 + x3
  Y =~ y1 + y2 + y3
  Z =~ z1 + z2 + z3
  
  # Inner model
  Y ~ X + Z + X:Z 
'
syntax <- get_pi_syntax(m1)
data <- get_pi_data(m1, oneInt)
est <- sem(syntax, data)
}
