% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/POEM.R
\name{POEM}
\alias{POEM}
\title{Nearest Neighbour Imputation with Mahalanobis distance}
\usage{
POEM(
  data,
  weights,
  outind,
  errors,
  missing.matrix,
  alpha = 0.5,
  beta = 0.5,
  reweight.out = FALSE,
  c = 5,
  preliminary.mean.imputation = FALSE,
  monitor = FALSE
)
}
\arguments{
\item{data}{a data frame or matrix with the data.}

\item{weights}{sampling weights.}

\item{outind}{an indicator vector for the outliers with \code{1} indicating
an outlier.}

\item{errors}{matrix of indicators for items which failed edits.}

\item{missing.matrix}{the missingness matrix can be given as input. Otherwise,
it will be recalculated.}

\item{alpha}{scalar giving the weight attributed to an item that is failing.}

\item{beta}{minimal overlap to accept a donor.}

\item{reweight.out}{if \code{TRUE}, the outliers are redefined.}

\item{c}{tuning constant when redefining the outliers (cutoff for Mahalanobis
distance).}

\item{preliminary.mean.imputation}{assume the problematic observation is at
the mean of good observations.}

\item{monitor}{if \code{TRUE} verbose output.}
}
\value{
\code{POEM} returns a list whose first component \code{output} is a
sub-list with the following components:
\describe{
  \item{\code{preliminary.mean.imputation}}{Logical. \code{TRUE} if preliminary
  mean imputation should be used}
  \item{\code{completely.missing}}{Number of observations with no observed values}
  \item{\code{good.values}}{Weighted number of of good values (not missing, not
  outlying, not erroneous)}
  \item{\code{nonoutliers.before}}{Number of nonoutliers before reweighting}
  \item{\code{weighted.nonoutliers.before}}{Weighted number of nonoutliers
  before reweighting}
  \item{\code{nonoutliers.after}}{Number of nonoutliers after reweighting}
  \item{\code{weighted.nonoutliers.after}}{Weighted number of nonoutliers after
  reweighting}
  \item{\code{old.center}}{Coordinate means after weighting, before imputation}
  \item{\code{old.variances}}{Coordinate variances after weighting, before imputation}
  \item{\code{new.center}}{Coordinate means after weighting, after imputation}
  \item{\code{new.variances}}{Coordinate variances after weighting, after imputation}
  \item{\code{covariance}}{Covariance (of standardised observations) before imputation}
  \item{\code{imputed.observations}}{Indices of observations with imputed values}
  \item{\code{donors}}{Indices of donors for imputed observations}
  \item{\code{new.outind}}{Indices of new outliers}
}
The further component returned by \code{POEM} is:
\describe{
  \item{\code{imputed.data}}{Imputed data set}
}
}
\description{
POEM takes into account missing values, outlier indicators, error indicators
and sampling weights.
}
\details{
\code{POEM} assumes that an multivariate outlier detection has been carried out
beforehand and assumes the result is summarized in the vector \code{outind}.
In addition, further observations may have been flagged as failing edit-rules
and this information is given in the vector \code{errors}. The mean and
covariance estimate is calculated with the good observations (no outliers and
downweighted errors). Preliminary mean imputation is sometimes needed to avoid
a non-positive definite covariance estimate at this stage. Preliminary mean
imputation assumes that the problematic values of an observation (with errors,
outliers or missing) can be replaced by the mean of the rest of the non-problematic
observations. Note that the algorithm imputes these problematic observations
afterwards and therefore the final covariance matrix with imputed data is not
the same as the working covariance matrix (which may be based on preliminary mean
imputation).
}
\examples{
data(bushfirem, bushfire.weights)
outliers <- rep(0, nrow(bushfirem))
outliers[31:38] <- 1
imp.res <- POEM(bushfirem, bushfire.weights, outliers,
preliminary.mean.imputation = TRUE)
print(imp.res$output)
var(imp.res$imputed.data)
}
\references{
Béguin, C. and Hulliger B., (2002), EUREDIT Workpackage x.2
D4-5.2.1-2.C Develop and evaluate new methods for statistical outlier
detection and outlier robust multivariate imputation, Technical report,
EUREDIT 2002.
}
\author{
Beat Hulliger
}
