% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighted.quantile.R
\name{weighted.quantile}
\alias{weighted.quantile}
\title{Quantiles of a weighted cdf}
\usage{
weighted.quantile(x, w, prob = 0.5, plot = FALSE)
}
\arguments{
\item{x}{a vector of data.}

\item{w}{a vector of (sampling) weights.}

\item{prob}{the probability for the quantile.}

\item{plot}{if \code{TRUE}, the weighted cdf is plotted.}
}
\value{
The quantile according to \code{prob} (by default it returns the weighted median).
}
\description{
A weighted cdf is calculated and quantiles are evaluated. Missing values are discarded.
}
\details{
Weighted linear interpolation in case of non-unique inverse. Gives a warning when the
contribution of the weight of the smallest observation to the total weight is larger
than \code{prob}.
}
\note{
No variance calculation.
}
\examples{
x <- rnorm(100)
x[sample(1:100, 20)] <- NA
w <- rchisq(100, 2)
weighted.quantile(x, w, 0.2, TRUE)
}
\seealso{
\href{https://www.rdocumentation.org/packages/survey/versions/3.33-2/topics/svyquantile}{svyquantile}
}
\author{
Beat Hulliger
}
