% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EAimp.R
\name{EAimp}
\alias{EAimp}
\title{Epidemic Algorithm for imputation of multivariate outliers in incomplete
survey data.}
\usage{
EAimp(data, weights, outind, reach = "max", transmission.function = "root",
  power = ncol(data), distance.type = "euclidean", duration = 5,
  maxl = 5, kdon = 1, monitor = FALSE, threshold = FALSE,
  deterministic = TRUE, fixedprop = 0)
}
\arguments{
\item{data}{a data frame or matrix with the data.}

\item{weights}{a vector of positive sampling weights.}

\item{outind}{a logical vector with component \code{TRUE} for outliers.}

\item{reach}{reach of the threshold function (usually set to the maximum
distance to a nearest neighbour, see internal function \code{EA.dist}).}

\item{transmission.function}{form of the transmission function of distance d:
\code{"step"} is a heaviside function which jumps to \code{1} at \code{d0},
\code{"linear"} is linear between \code{0} and \code{d0}, \code{"power"} is
\code{beta*d+1^(-p)} for \code{p=ncol(data)} as default, \code{"root"} is the
function \code{1-(1-d/d0)^(1/maxl)}.}

\item{power}{sets \code{p=power}, where \code{p} is the parameter in the above
transmission function.}

\item{distance.type}{distance type in function \code{dist()}.}

\item{duration}{the duration of the detection epidemic.}

\item{maxl}{maximum number of steps without infection.}

\item{kdon}{the number of donors that should be infected before imputation.}

\item{monitor}{if \code{TRUE} verbose output on epidemic.}

\item{threshold}{Infect all remaining points with infection probability above
the threshold \code{1-0.5^(1/maxl)}.}

\item{deterministic}{if \code{TRUE} the number of infections is the expected
number and the infected observations are the ones with largest infection
probabilities.}

\item{fixedprop}{if \code{TRUE} a fixed proportion of observations is infected
at each step.}
}
\value{
\code{EAimp} returns a list with two components: \code{parameters} and
\code{imputed.data}.
\code{parameters} contains the following elements:
\describe{
  \item{\code{sample.size}}{Number of observations}
  \item{\code{number.of.variables}}{Number of variables}
  \item{\code{n.complete.records}}{Number of records without missing values}
  \item{\code{n.usable.records}}{Number of records with less than half of values
  missing (unusable observations are discarded)}
  \item{\code{duration}}{Duration of epidemic}
  \item{\code{reach}}{Transmission distance (\code{d0})}
  \item{\code{threshold}}{Input parameter}
  \item{\code{deterministic}}{Input parameter}
  \item{\code{computation.time}}{Elapsed computation time}
}
\code{imputed.data} contains the imputed data.
}
\description{
After running \code{EAdet} an imputation of the detected outliers with
\code{EAimp} may be run.
}
\details{
\code{EAimp} uses the distances calculated in \code{EAdet} (actually the
counterprobabilities, which are stored in a global data set) and starts an
epidemic at each observation to be imputed until donors for the missing values
are infected. Then a donor is selected randomly.
}
\examples{
data(bushfirem, bushfire.weights)
det.res <- EAdet(bushfirem, bushfire.weights)
imp.res <- EAimp(bushfirem, bushfire.weights, outind = det.res$outind,
reach = det.res$output$max.min.di, kdon = 3)
print(imp.res$output)
}
\references{
Béguin, C. and Hulliger, B. (2004) Multivariate outlier detection in
incomplete survey data: the epidemic algorithm and transformed rank correlations,
JRSS-A, 167, Part 2, pp. 275-294.
}
\seealso{
\code{\link{EAdet}} for outlier detection with the Epidemic Algorithm.
}
\author{
Beat Hulliger
}
