% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/code.R
\name{suggest_probCut}
\alias{suggest_probCut}
\title{Compare Class Probability Distribution based on Probability Cut-off}
\usage{
suggest_probCut(addTo, outChar, predTag = "pred_test", modelTag = NULL)
}
\arguments{
\item{addTo}{Summary list that contains model fits to compare.}

\item{outChar}{A charactor value of output class name.}

\item{predTag}{Select prediction results that contains predTag on their name.}

\item{modelTag}{Select model fits that contains modelTag on their name.}
}
\value{
Plot indicating density distribution by probability cut-off.
}
\description{
\code{suggest_probCut} Compare class probability distribution
based on probability cut-off.
x-axis: probability value.
y-axis: observation density.
}
\examples{
\dontrun{
library(mlbench)
data(PimaIndiansDiabetes)
index <- sample(seq_len(nrow(PimaIndiansDiabetes)), 500)
trainingSet <- PimaIndiansDiabetes[index, ]
testSet <- PimaIndiansDiabetes[-index, ]
x <- trainingSet[, -9]
y <- trainingSet[, 9]
x_test <- testSet[, -9]
y_test <- testSet[, 9]
sSummary <- list()
sSummary <- add_model(sSummary, x, y)
sSummary <- add_model(sSummary, x, y, model = c("C5.0Cost", "glmnet"), modelTag = "others")
sSummary <- add_prob(sSummary, x_test, y_test, outChar = "pos")

suggest_probCut(sSummary, "pos")
suggest_probCut(sSummary, "pos", modelTag = "glm|svm")

# vignette("modeval") #check a vignette for further details
}
}
