% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nested-modeltime_fit.R
\name{modeltime_nested_fit}
\alias{modeltime_nested_fit}
\title{Fit Tidymodels Workflows to Nested Time Series}
\usage{
modeltime_nested_fit(
  nested_data,
  ...,
  model_list = NULL,
  metric_set = default_forecast_accuracy_metric_set(),
  conf_interval = 0.95,
  control = control_nested_fit()
)
}
\arguments{
\item{nested_data}{Nested time series data}

\item{...}{Tidymodels \code{workflow} objects that will be fit to the nested time series data.}

\item{model_list}{Optionally, a \code{list()} of Tidymodels \code{workflow} objects can be provided}

\item{metric_set}{A \code{yardstick::metric_set()} that is used to summarize one or more
forecast accuracy (regression) metrics.}

\item{conf_interval}{An estimated confidence interval based on the calibration data.
This is designed to estimate future confidence from \emph{out-of-sample prediction error}.}

\item{control}{Used to control verbosity and parallel processing. See \code{\link[=control_nested_fit]{control_nested_fit()}}.}
}
\description{
Fits one or more \code{tidymodels} workflow objects to nested time series data using the following process:
\enumerate{
\item Models are iteratively fit to training splits.
\item Accuracy is calculated on testing splits and is logged.
Accuracy results can be retrieved with \code{\link[=extract_nested_test_accuracy]{extract_nested_test_accuracy()}}
\item Any model that returns an error is logged.
Error logs can be retrieved with \code{\link[=extract_nested_error_report]{extract_nested_error_report()}}
\item Forecast is predicted on testing splits and is logged.
Forecast results can be retrieved with \code{\link[=extract_nested_test_forecast]{extract_nested_test_forecast()}}
}
}
\details{
\subsection{Preparing Data for Nested Forecasting}{

Use \code{\link[=extend_timeseries]{extend_timeseries()}}, \code{\link[=nest_timeseries]{nest_timeseries()}}, and \code{\link[=split_nested_timeseries]{split_nested_timeseries()}} for preparing
data for Nested Forecasting. The structure must be a nested data frame, which is suppplied in
\code{modeltime_nested_fit(nested_data)}.
}

\subsection{Fitting Models}{

Models must be in the form of \verb{tidymodels workflow} objects. The models can be provided in two ways:
\enumerate{
\item Using \code{...} (dots): The workflow objects can be provided as dots.
\item Using \code{model_list} parameter: You can supply one or more workflow objects that are wrapped in a \code{list()}.
}
}

\subsection{Controlling the fitting process}{

A \code{control} object can be provided during fitting to adjust the verbosity and parallel processing.
See \code{\link[=control_nested_fit]{control_nested_fit()}}.
}
}
