% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsnip-fit_methods.R
\name{fit.modeltime}
\alias{fit.modeltime}
\alias{fit.arima_reg}
\alias{fit.arima_boost}
\alias{fit.exp_smoothing}
\alias{fit.prophet_reg}
\alias{fit.prophet_boost}
\alias{fit.seasonal_decomp}
\title{Fit a Model Specification to a Dataset}
\usage{
\method{fit}{arima_reg}(object, formula, data, control = control_parsnip(), ...)

\method{fit}{arima_boost}(object, formula, data, control = control_parsnip(), ...)

\method{fit}{exp_smoothing}(object, formula, data, control = control_parsnip(), ...)

\method{fit}{prophet_reg}(object, formula, data, control = control_parsnip(), ...)

\method{fit}{prophet_boost}(object, formula, data, control = control_parsnip(), ...)

\method{fit}{seasonal_decomp}(object, formula, data, control = control_parsnip(), ...)
}
\arguments{
\item{object}{An object of class \code{model_spec} that has a chosen engine
(via \code{\link[parsnip:set_engine]{set_engine()}}).}

\item{formula}{An object of class "formula" (or one that can
be coerced to that class): a symbolic description of the model
to be fitted.}

\item{data}{Optional, depending on the interface (see Details
below). A data frame containing all relevant variables (e.g.
outcome(s), predictors, case weights, etc). Note: when needed, a
\emph{named argument} should be used.}

\item{control}{A named list with elements \code{verbosity} and
\code{catch}. See \code{\link[parsnip:control_parsnip]{control_parsnip()}}.}

\item{...}{Not currently used; values passed here will be
ignored. Other options required to fit the model should be
passed using \code{set_engine()}.}
}
\value{
A \code{model_fit} object that contains several elements:
\itemize{
\item \code{lvl}: If the outcome is a factor, this contains
the factor levels at the time of model fitting.
\item \code{spec}: The model specification object
(\code{object} in the call to \code{fit})
\item \code{fit}: when the model is executed without error,
this is the model object. Otherwise, it is a \code{try-error}
object with the error message.
\item \code{preproc}: any objects needed to convert between
a formula and non-formula interface (such as the \code{terms}
object)
}
The return value will also have a class related to the fitted model (e.g.
\code{"_glm"}) before the base class of \code{"model_fit"}.
}
\description{
\code{fit()} and \code{fit_xy()} take a model specification, translate the required
code by substituting arguments, and execute the model fit
routine.
}
\details{
\code{fit()} and \code{fit_xy()} substitute the current arguments in the model
specification into the computational engine's code, checks them
for validity, then fits the model using the data and the
engine-specific code. Different model functions have different
interfaces (e.g. formula or \code{x}/\code{y}) and these functions translate
between the interface used when \code{fit()} or \code{fit_xy()} were invoked and the one
required by the underlying model.

When possible, these functions attempt to avoid making copies of the
data. For example, if the underlying model uses a formula and
\code{fit()} is invoked, the original data are references
when the model is fit. However, if the underlying model uses
something else, such as \code{x}/\code{y}, the formula is evaluated and
the data are converted to the required format. In this case, any
calls in the resulting model objects reference the temporary
objects used to fit the model.

If the model engine has not been set, the model's default engine will be used
(as discussed on each model page). If the \code{verbosity} option of
\code{\link[=control_parsnip]{control_parsnip()}} is greater than zero, a warning will be produced.
}
\examples{
# TODO


}
