% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modules.R
\name{module}
\alias{module}
\title{R6 class representing a module}
\description{
R6 class representing a module

R6 class representing a module
}
\details{
A module is a  set of graph operation combined together.
}
\author{
Filippo Monari
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{module$new()}}
\item \href{#method-name}{\code{module$name()}}
\item \href{#method-save}{\code{module$save()}}
\item \href{#method-op}{\code{module$op()}}
\item \href{#method-obj}{\code{module$obj()}}
\item \href{#method-pars}{\code{module$pars()}}
\item \href{#method-npars}{\code{module$npars()}}
\item \href{#method-y}{\code{module$y()}}
\item \href{#method-j}{\code{module$j()}}
\item \href{#method-clone}{\code{module$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
It just sets the name of the module
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{module$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{initialisation arguments}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-name"></a>}}
\if{latex}{\out{\hypertarget{method-name}{}}}
\subsection{Method \code{name()}}{
Returns the name of the module
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{module$name()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns the name of the module
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-save"></a>}}
\if{latex}{\out{\hypertarget{method-save}{}}}
\subsection{Method \code{save()}}{
Saves the module in RDS format
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{module$save(of, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{of}}{out file name}

\item{\code{...}}{additional arguments to pass to \code{saveRDS}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-op"></a>}}
\if{latex}{\out{\hypertarget{method-op}{}}}
\subsection{Method \code{op()}}{
The operator method implements the calculations happeing in the module.
This method must be implemented for each object inheriting the class 'module'.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{module$op(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{arguments for the calculations}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns a reference object of class 'number'
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-obj"></a>}}
\if{latex}{\out{\hypertarget{method-obj}{}}}
\subsection{Method \code{obj()}}{
In the case the module represents a full model, the objective method must be
implemented.
This method method implements the calculations returning the value of the
objective function that has to be optimised during the model training.
Its first argument must the targets, and its second argument must be
the input matrix.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{module$obj(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{arguments for the calculations}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns a reference object of class 'number' of rank 0
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pars"></a>}}
\if{latex}{\out{\hypertarget{method-pars}{}}}
\subsection{Method \code{pars()}}{
The pars method has to return a flat list containing all the parameters of
the module (reference object of class 'number').
This method must be implemented for each object inheriting the class 'module'.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{module$pars()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns a flat list containing the module parameters 
(reference object of class 'number')
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-npars"></a>}}
\if{latex}{\out{\hypertarget{method-npars}{}}}
\subsection{Method \code{npars()}}{
This method return the total size of the module parameters,
that is the sum of the sizes of the individual \code{numbers}
parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{module$npars()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns the total number of parameters
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-y"></a>}}
\if{latex}{\out{\hypertarget{method-y}{}}}
\subsection{Method \code{y()}}{
Returns the reference object of class 'number' containing the output of the
operator method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{module$y()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-j"></a>}}
\if{latex}{\out{\hypertarget{method-j}{}}}
\subsection{Method \code{j()}}{
Returns the reference object of class 'number' containing the output of the
objective method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{module$j()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{module$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
