% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variable_binning.R
\name{vector_bin}
\alias{vector_bin}
\title{Bin a vector into equal height, equal width, or custom bins}
\usage{
vector_bin(x, bins, type = "height", na_include = TRUE)
}
\arguments{
\item{x}{vector of numeric data to bin}

\item{bins}{numeric vector. If length 1, then this is taken to be the number of
desired bins, computed according to "type". If length > 1, this is taken
to be the actual cutpoints desired}

\item{type}{character, equal to "height" or "width". Only used if length(bins) == 1.
If "height", then bins are computed to have roughly equal numbers of
observations; else, bins are computed to be of roughly equal width}

\item{na_include}{logical. If TRUE, then a bin labelled "missing" will be included
in the output. Else NA values are dropped}
}
\value{
the input vector x, with values replaced by the appropriate bins.
        Type also changed to factor
}
\description{
This function essentially calls \code{\link[base]{cut}}/
\code{\link[ggplot2]{cut_interval}}/\code{\link[ggplot2]{cut_number}},
depending on the value of bins and type. The one major difference is in the
treatment of missing values; those functions return NA, while vector_bin has
the default option of returning a bin for the missing values
}
\examples{
x <- rnorm(100)
y <- x; y[sample(1:100,20)] <- NA

cut(x,c(-1,0,1))
vector_bin(x,bins = c(-1,0,1))
cut(y,c(-1,0,1))
vector_bin(y,bins = c(-1,0,1))
vector_bin(y,bins = c(-1,0,1),na_include = FALSE)

ggplot2::cut_number(x,5)
vector_bin(x,5)

ggplot2::cut_interval(x,5)
vector_bin(x,5,type = "width")
}
\seealso{
\code{\link[base]{cut}}, \code{\link[ggplot2]{cut_number}},
\code{\link[ggplot2]{cut_interval}},

Other discretization: \code{\link{binned_data_cutpoints}},
  \code{\link{get_vector_cutpoints}},
  \code{\link{simple_bin}}
}

