% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consolidate_model.R
\name{consolidate_model}
\alias{consolidate_model}
\title{Consolidate model settings to a complete caret model specification}
\usage{
consolidate_model(shared_settings, model)
}
\arguments{
\item{shared_settings}{\code{list}, settings that are shared by all models by
default.}

\item{model}{\code{list}, the individual specifications of a model in a
model grid.}
}
\value{
\code{list}, a complete model and training specification, that
can be trained with caret.
}
\description{
Consolidate model (and model training) settings from shared and model specific
settings to one complete caret model specification. In case there is an overlap
between the two, the model specific settings will apply.
}
\examples{
library(magrittr)
library(dplyr)
library(caret)

# create model grid.
mg <-
  model_grid() \%>\%
  share_settings(y = iris[["Species"]],
                 x = iris \%>\% select(-Species),
                 trControl = trainControl()) \%>\%
  add_model("FunkyForest", method = "rf",
            preProc = c("center", "scale", "pca"),
            custom_control = list(preProcOptions = list(thresh = 0.8)))

# consolidate all settings to complete caret model specification.
consolidate_model(mg$shared_settings, mg$models$FunkyForest)
}
