% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binom_lims.R
\name{binom_lims}
\alias{binom_lims}
\title{Maximum likelihood parameter estimates for a psychometric function with guessing and lapsing rates}
\usage{
binom_lims( r, m, x, gl = "both", link = "logit", p = 1, K = 2, initval = NULL )
}
\arguments{
\item{r}{number of successes at points x}

\item{m}{number of trials at points x}

\item{x}{stimulus levels}

\item{gl}{(optional) indicator, calulate only guessing if "guessing", only lapsing if "lapsing" and both guessing and lapsing if "both"; default is "both"}

\item{link}{(optional) name of the link function; default is "logit"}

\item{p}{(optional) degree of the polynomial; default is 1}

\item{K}{(optional) power parameter for Weibull and reverse Weibull link; default is 2}

\item{initval}{(optional) initial value for guessing and lapsing; default is c(.01 .01) if guessing and rates are estimated, and .01 if only guessing or only lapsing rate is estimated}
}
\value{
\verb{b         }estimated coefficients for the linear part

\verb{guessing  } estimated guessing rate (if estimated)

\verb{lapsing   } estimated lapsing rate (if estimated)

\verb{fit       } glm object to be used in evaluation of fitted values
}
\description{
This function finds the maximum likelihood estimates of the parameters
of the psychometric function with guessing and lapsing rates, only
guessing rate, or only lapsing rate.
}
\examples{
data("Baker_etal")
x = Baker_etal$x
r = Baker_etal$r
m = Baker_etal$m
plot( x, r / m, xlim = c( 0.16, 7.83 ), ylim = c( -0.01, 1.01 ), type = "p", pch="*" )
val <- binomfit_lims( r, m, x, link = "probit" )
numxfit <- 199; # Number of new points to be generated minus 1
xfit <- (max(x)-min(x)) * (0:numxfit) / numxfit + min(x)
# Plot the fitted curve
pfit<-predict( val$fit, data.frame( x = xfit ), type = "response" )
lines(xfit, pfit )
}
