% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bandwidth_bootstrap.R
\name{bandwidth_bootstrap}
\alias{bandwidth_bootstrap}
\title{Bootstrap bandwidth for local polynomial estimator of a psychometric function}
\usage{
bandwidth_bootstrap( r, m, x, H, N, h0 = NULL, link = "logit",
                     guessing = 0, lapsing = 0, K = 2, p = 1,
                     ker = "dnorm", maxiter = 50, tol = 1e-6, method = "all")
}
\arguments{
\item{r}{number of successes at points x}

\item{m}{number of trials at points x}

\item{x}{stimulus levels}

\item{H}{search interval}

\item{N}{number of bootstrap replications}

\item{h0}{(optional) pilot bandwidth; if not specified, then the scaled plug-in bandwidth is used}

\item{link}{(optional) name of the link function to be used; default is "logit"}

\item{guessing}{(optional) guessing rate; default is 0}

\item{lapsing}{(optional) lapsing rate; default is 0}

\item{K}{(optional) power parameter for Weibull and reverse Weibull link; default is 2}

\item{p}{(optional) degree of the polynomial; default is 1}

\item{ker}{(optional) kernel function for weights; default is "dnorm"}

\item{maxiter}{(optional) maximum number of iterations in Fisher scoring; default is 50}

\item{tol}{(optional) tolerance level at which to stop Fisher scoring; default is 1e-6}

\item{method}{(optional) loss function to be used in bootstrap: choose from: "ISEeta", "ISE", "deviance"; by default all possible values are calculated}
}
\value{
\verb{h  } bootstrap bandwidth for the chosen "method"; if no "method" is specified, then it has three components: $pscale, $eta-scale and $deviance
}
\description{
This function finds a bootstrap estimate of the optimal bandwidth h for a local polynomial
estimate of the psychometric function with specified guessing and lapsing rates.
}
\examples{
data("Baker_etal")
x = Baker_etal$x
r = Baker_etal$r
m = Baker_etal$m
plot( x, r / m, xlim = c( 0.16, 7.83 ), ylim = c( -0.01, 1.01 ), type = "p", pch="*" )
val <- binomfit_lims( r, m, x, link = "probit" )
numxfit <- 199; # Number of new points to be generated minus 1
xfit <- (max(x)-min(x)) * (0:numxfit) / numxfit + min(x)
# Plot the fitted curve
pfit<-predict( val$fit, data.frame( x = xfit ), type = "response" )
lines(xfit, pfit )
\dontrun{
data("Miranda_Henson")
x = Miranda_Henson$x
r = Miranda_Henson$r
m = Miranda_Henson$m
numxfit <- 199; # Number of new points to be generated minus 1
xfit <- (max(x)-min(x)) * (0:numxfit) / numxfit + min(x)
# Find a cross-validation bandwidth
bwd_min <- min( diff( x ) )
bwd_max <- max( x ) - min( x )
# This might take a few minutes
niter <- 500 # Note number of bootstrap iterations should be at least 500
bwd <- bandwidth_bootstrap( r, m, x, c( bwd_min, bwd_max ),niter, method="deviance")
pfit <- locglmfit( xfit, r, m, x, bwd )$pfit
# Plot the fitted curve
plot( x, r / m, xlim = c( 0.1, 1.302 ), ylim = c( 0.0165, 0.965 ), type = "p", pch="*" )
lines(xfit, pfit )
}
}
