% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot.auc_coxph.R, R/ggplot.roc_coxph.R,
%   R/ggplot.roc_logit.R
\name{ggplot}
\alias{ggplot}
\alias{ggplot.auc_coxph}
\alias{ggplot.roc_coxph}
\alias{ggplot.roc_logit}
\title{Plot for ROC curve}
\usage{
\method{ggplot}{auc_coxph}(
  data,
  mapping,
  color = NULL,
  lwd = 1.05,
  grid.space = 2,
  ncol = NULL,
  ...,
  environment = parent.frame()
)

\method{ggplot}{roc_coxph}(
  data,
  mapping,
  color = NULL,
  lwd = 1.05,
  grid.space = 2,
  rank = FALSE,
  ncol = NULL,
  ...,
  environment = parent.frame()
)

\method{ggplot}{roc_logit}(
  data,
  mapping,
  color = NULL,
  lwd = 1.05,
  grid.space = 2,
  rank = FALSE,
  ...,
  environment = parent.frame()
)
}
\arguments{
\item{data}{resultes of roc() function}

\item{mapping}{ignore}

\item{color}{one or more colors}

\item{lwd}{logical or integers}

\item{grid.space}{space between grids, default is 2}

\item{ncol}{number of column for grid plot}

\item{...}{ignore}

\item{environment}{ignore}

\item{rank}{rank by AUC}
}
\value{
a ggplot picture.
}
\description{
Plot for ROC curve
}
\examples{
\donttest{
library(ggDCA)
library(rms)
library(modelROC)
###  COX ----------

fit <- cph(Surv(time,status)~ANLN+CENPA+GPR182,LIRI)

####        one model, one time ####
#----            auc for model

r <- auc(fit,
          model='This is model') # one model
unique(r)
ggplot(r)

r <- auc(fit,
          model=TRUE)            # all model
unique(r)
ggplot(r)


#----            auc for x
r <- auc(fit,
          x='ANLN')              # one x
unique(r)
ggplot(r)

r <- auc(fit,
          x=c('ANLN','CENPA'))   # more x
unique(r)
ggplot(r)

r <- auc(fit,
          x=TRUE)                # all x
unique(r)
ggplot(r)

r <- auc(fit,
          model=TRUE,            # one model
          x=TRUE)                # all x
unique(r)
ggplot(r)

r <- auc(fit,
          model='Three Genes',   # specify model names
          x=TRUE)                # all X
unique(r)
ggplot(r)



####        more models ####
fit2 <- cph(Surv(time,status)~ANLN+CENPA,LIRI)


r <- auc(fit,fit2,
          model=c('Three Genes','Two Genes'))            #
unique(r)
ggplot(r)



r <- auc(fit,fit2,
          model=TRUE,
          x=TRUE)
unique(r)
ggplot(r)
}
library(ggDCA)
library(rms)
fit <- lrm(status~ANLN+CENPA+GPR182,LIRI)
####        one model ####
pp <- roc(fit,
          model=TRUE) # one model
unique(pp)
ggplot(pp)

pp <- roc(fit,
          x='ANLN') # one x
unique(pp)
ggplot(pp)

\donttest{
pp <- roc(fit,
          x=c('ANLN','CENPA')) # more x
unique(pp)
ggplot(pp)


pp <- roc(fit,
          x=TRUE) # ALL x
unique(pp)
ggplot(pp)


pp <- roc(fit,
          model=TRUE, # one model
          x=TRUE) # ALL x
unique(pp)
ggplot(pp)

pp <- roc(fit,
          model='Three Genes', # specify model name
          x=TRUE) # ALL x
unique(pp)
ggplot(pp)

####        more model   ####

fit2 <- lrm(status~ANLN+CENPA,LIRI)
pp <- roc(fit,fit2,
          model=TRUE) # all model
unique(pp)
ggplot(pp)


pp <- roc(fit,fit2,
          model=c('Three Genes','Two Genes')) # specify model names
unique(pp)
ggplot(pp)

pp <- roc(fit,fit2,
          x=TRUE,                             # all x
          model=c('Three Genes','Two Genes')) # all model
unique(pp)
ggplot(pp)

###  COX ----------

fit <- cph(Surv(time,status)~ANLN+CENPA+GPR182,LIRI)
range(LIRI$time)
####        one model, one time ####
#----            roc for model

pp <- roc(fit, times=1,
          model='This is model') # one model
unique(pp)
ggplot(pp)

pp <- roc(fit, times=1,
          model=TRUE)            # all model
unique(pp)
ggplot(pp)

#----            roc for x
pp <- roc(fit, times=1,
          x='ANLN')              # one x
unique(pp)
ggplot(pp)

pp <- roc(fit, times=1,
          x=c('ANLN','CENPA'))   # more x
unique(pp)
ggplot(pp)

pp <- roc(fit, times=1,
          x=TRUE)                # all x
unique(pp)
ggplot(pp)

pp <- roc(fit, times=1,
          model=TRUE,            # one model
          x=TRUE)                # all x
unique(pp)
ggplot(pp)

pp <- roc(fit, times=1,
          model='Three Genes',   # specify model names
          x=TRUE)                # all X
unique(pp)
ggplot(pp)

####        one model, more time ####

pp <- roc(fit, times=c(1,2,3,4,5,6),
          model=TRUE)            # one model
unique(pp)
ggplot(pp)


pp <- roc(fit, times=c(1,2),
          x =  'ANLN')           # one x

unique(pp)
ggplot(pp)


pp <- roc(fit, times=c(1,2,3,4,5,6),
          x = c('ANLN','CENPA')) # more x
unique(pp)
ggplot(pp,ncol = 3)


pp <- roc(fit, times=c(1,2),
          model=TRUE,            # one model
          x = TRUE) # all x
unique(pp)
ggplot(pp)

####        more models, one time ####
fit2 <- cph(Surv(time,status)~ANLN+CENPA,LIRI)

pp <- roc(fit,fit2,times=1,
          x=TRUE,
          model=c('Three Genes','Two Genes'))            #
unique(pp)
ggplot(pp)
####        more models, more time ####
pp <- roc(fit,fit2,times=c(1,2),
          model=c('Three Genes','Two Genes'))            #
unique(pp)
ggplot(pp)

pp <- roc(fit,fit2,times=c(1,2),
          x=TRUE,
          model=c('Three Genes','Two Genes'))            #
unique(pp)
ggplot(pp)
}
}
