% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-pmtree.R
\name{node_pmterminal}
\alias{node_pmterminal}
\title{Panel-Generator for Visualization of pmtrees}
\usage{
node_pmterminal(obj, coeftable = TRUE, digits = 2, confint = TRUE,
  plotfun, nid = function(node) paste0(nam[id_node(node)], ", n = ",
  node$info$nobs), ...)
}
\arguments{
\item{obj}{an object of class party.}

\item{coeftable}{should a table with coefficients be added to the plot?}

\item{digits}{integer, used for formating numbers.}

\item{confint}{Should a confidence interval be computed.}

\item{plotfun}{Plotting function to be used. Needs to be of format
\code{function(mod, data)} where \code{mod} is the model object.
See examples for more details.}

\item{nid}{function to retrieve info on what is plottet as node ids.}

\item{...}{arguments passed on to plotfun.}
}
\description{
The plot method for party and constparty objects are rather flexible and can
be extended by panel functions. The pre-defined panel-generating function of
class grapcon_generator for pmtrees is documented here.
}
\examples{
if(require("survival")) {
## compute survreg model
mod_surv <- survreg(Surv(futime, fustat) ~ factor(rx), ovarian, dist='weibull')
survreg_plot(mod_surv)

## partition model and plot
tr_surv <- pmtree(mod_surv)
plot(tr_surv, terminal_panel = node_pmterminal(tr_surv, plotfun = survreg_plot,
                                               confint = TRUE))
}

}
