% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmodel-test.R
\name{test_heterogeneity}
\alias{test_heterogeneity}
\alias{plot.heterogeneity_test}
\title{Test if personalised models improve upon 
base model.}
\usage{
test_heterogeneity(forest, pmodels = NULL, data = NULL, B = 100)

\method{plot}{heterogeneity_test}(x, ...)
}
\arguments{
\item{forest}{pmforest object.}

\item{pmodels}{pmodel.identity object (pmodel(..., fun = identity)).}

\item{data}{data.}

\item{B}{number of bootstrap samples.}

\item{x}{object of class heterogeneity_test.}

\item{...}{ignored.}
}
\value{
list where the first element is the p-value und the 
second element is a data.frame with all neccessary infos to
compute the p-value.
}
\description{
This is a rudimentary test if there is 
heterogeneity in the model parameters.
}
\examples{
\dontrun{
set.seed(123)
n <- 160
trt <- factor(rep(0:1, each = n/2))
y <- 4 + (trt == 1) + rnorm(n)
z <- matrix(rnorm(n * 2), ncol = 2)

dat <- data.frame(y, trt, z)

mod <- lm(y ~ trt, data = dat)

## Note that ntree should usually be higher
frst <- pmforest(mod, ntree = 20) 
pmods <- pmodel(frst, fun = identity)

## Note that B should be at least 100
## The low B is just for demonstration 
## purposes.
tst <- test_heterogeneity(forest = frst, 
                          pmodels = pmods, 
                          model = mod,
                          B = 10) 
tst$pvalue
plot(tst)
}

}
