% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sim_Community.R
\name{sim_poisson_community}
\alias{sim_poisson_community}
\title{Simulate community with random spatial positions.}
\usage{
sim_poisson_community(
  s_pool,
  n_sim,
  sad_type = "lnorm",
  sad_coef = list(cv_abund = 1),
  fix_s_sim = FALSE,
  xrange = c(0, 1),
  yrange = c(0, 1)
)
}
\arguments{
\item{s_pool}{Number of species in the pool (integer)}

\item{n_sim}{Number of individuals in the simulated community (integer)}

\item{sad_type}{Root name of the species abundance distribution model of the
  species pool (character) - e.g., "lnorm" for the lognormal distribution
  (\code{\link[stats]{rlnorm}}); "geom" for the geometric distribution
  (\code{\link[stats]{rgeom}}), or "ls" for Fisher's log-series distribution
  (\code{\link[sads]{rls}}).

  See the table in \strong{Details} below, or \code{\link[sads]{rsad}}
  for all SAD model options.}

\item{sad_coef}{List with named arguments to be passed to the distribution
  function defined by the argument \code{sad_type}. An overview of parameter
  names is given in the table below.

  In \code{mobsim} the log-normal and the Poisson log-normal distributions
  can alternatively be parameterized by the coefficient of variation (cv)
  of the relative abundances in the species pool. Accordingly, \code{cv_abund}
  is the standard deviation of abundances divided by the mean abundance
  (no. of individuals / no. of species). \code{cv_abund} is thus negatively
  correlated with the evenness of the species abundance distribution.

  Please note that the parameters \emph{mu} and \emph{sigma} are not equal
  to the mean and standard deviation of the log-normal distribution.}

\item{fix_s_sim}{Should the simulation constrain the number of
species in the simulated local community? (logical)}

\item{xrange}{Extent of the community in x-direction (numeric vector of length 2)}

\item{yrange}{Extent of the community in y-direction (numeric vector of length 2)}
}
\value{
A community object as defined by \code{\link{community}}.
}
\description{
This function simulates a community with a certain abundance distribution and
and random spatial coordinates. This function consecutively calls
\code{\link{sim_sad}} and \code{\link{sim_poisson_coords}}
}
\examples{
com1 <- sim_poisson_community(s_pool = 20, n_sim = 500, sad_type = "lnorm",
sad_coef = list("meanlog" = 2, "sdlog" = 1))
plot(com1)

}
\author{
Felix May
}
