% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool_bin.R
\name{pool_bin}
\alias{pool_bin}
\title{Monotonic binning for the pool data}
\usage{
pool_bin(x, num, den)
}
\arguments{
\item{x}{A numeric vector}

\item{num}{A numeric vector with integer values for numerators to calculate bad rates}

\item{den}{A numeric vector with integer values for denominators to calculate bad rates}
}
\value{
A list of binning outcomes, including a numeric vector with cut
        points and a dataframe with binning summary
}
\description{
The function \code{pool_bin} implements the monotonic binning for the pool data
based on the generalized boosted model (GBM).
}
\examples{
data(hmeq)
df <- rbind(Reduce(rbind, 
                   lapply(split(hmeq, floor(hmeq$CLAGE)),
                          function(d) data.frame(AGE = unique(floor(d$CLAGE)),
                                                 NUM = sum(d$BAD),
                                                 DEN = nrow(d)))),
            data.frame(AGE = NA, 
                       NUM = sum(hmeq[is.na(hmeq$CLAGE), ]$BAD),
                       DEN = nrow(hmeq[is.na(hmeq$CLAGE), ])))
pool_bin(df$AGE, df$NUM, df$DEN) 
}
