% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_woe.R
\name{batch_woe}
\alias{batch_woe}
\title{Apply WoE transformations to vectors in dataframe}
\usage{
batch_woe(xs, bin_out)
}
\arguments{
\item{xs}{A dataframe with numeric vectors to discretize.}

\item{bin_out}{A binning output from the function batch_bin().}
}
\value{
A dataframe with identical headers as the input xs. However, values
        of each variable have been transformed to WoE values.
}
\description{
The function \code{batch_woe} applies WoE transformations to vectors 
in the dataframe.
}
\examples{
data(hmeq)
bin_out <- batch_bin(hmeq$BAD, hmeq[, c('DEROG', 'DELINQ')])$bin_out
head(batch_woe(hmeq[, c('DEROG', 'DELINQ')], bin_out))
}
