% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teststatistics.R
\name{MSkew}
\alias{MSkew}
\title{Mardias measure of multivariate sample skewness}
\usage{
MSkew(data)
}
\arguments{
\item{data}{a n x d matrix of d dimensional data vectors.}
}
\value{
value of sample skewness in the sense of Mardia.
}
\description{
This function computes the classical invariant measure of multivariate sample skewness due to Mardia (1970).
}
\details{
Multivariate sample skewness due to Mardia (1970) is defined by
\deqn{b_{n,d}^{(1)}=\frac{1}{n^2}\sum_{j,k=1}^n(Y_{n,j}^\top Y_{n,k})^3,}
where \eqn{Y_{n,j}=S_n^{-1/2}(X_j-\overline{X}_n)}, \eqn{\overline{X}_n} is the sample mean and \eqn{S_n} is the sample covariance matrix of the random vectors \eqn{X_1,\ldots,X_n}. To ensure that the computation works properly
\eqn{n \ge d+1} is needed. If that is not the case the function returns an error. Note that for \eqn{d=1}, we have a measure proportional to the squared sample skewness.
}
\examples{
MSkew(MASS::mvrnorm(50,c(0,1),diag(1,2)))

}
\references{
Mardia, K.V. (1970), Measures of multivariate skewness and kurtosis with applications, Biometrika, 57:519–530.

Henze, N. (2002), Invariant tests for multivariate normality: a critical review, Statistical Papers, 43:467–506.
}
