% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnis_political_interests.R
\name{mnis_political_interests}
\alias{mnis_political_interests}
\title{Political and Geographical Interests}
\usage{
mnis_political_interests(
  interest,
  house = NULL,
  current = TRUE,
  tidy = TRUE,
  tidy_style = "snake_case"
)
}
\arguments{
\item{interest}{A single interest in the form of a string, or a character
vector of interests. If a vector of multiple interests, returns all members
who list all of those interests.}

\item{house}{The house the member belongs to. Accepts 'commons', 'lords'
and \code{NULL}. This variable is not case sensitive. If \code{NULL},
returns members from both houses. Defaults to \code{NULL}.}

\item{current}{Logical. If \code{TRUE}, returns all current and
former members of both houses. Defaults to \code{TRUE}.}

\item{tidy}{If \code{TRUE}, fixes the variable names in the tibble to
remove non-alphanumeric characters and superfluous text, and convert to
a consistent style. Defaults to \code{TRUE}.}

\item{tidy_style}{The style to convert variable names to, if
\code{tidy=TRUE}. Accepts one of \code{"snake_case"}, \code{"camelCase"} and
\code{"period.case"}. Defaults to \code{"snake_case"}.}
}
\value{
A data frame of members with given interest(s).
}
\description{
Returns a tibble with members with the specified interest or interests.
}
\examples{
\dontrun{
x <- mnis_political_interests(c("Africa", "Jamaica"))

y <- mnis_political_interests(c("Africa", "Europe"))

z <- mnis_political_interests(c("Africa", "Education"))
}

}
