% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnis_lords_type.R
\name{mnis_lords_type}
\alias{mnis_lords_type}
\title{Calls the API to return a tibble with details on the number of Lords and their affiliations.}
\usage{
mnis_lords_type(date = Sys.Date(), tidy = TRUE, tidy_style = "snake_case")
}
\arguments{
\item{date}{Accepts character values in "YYYY-MM-DD" format, and objects of class Date, POSIXt, POSIXct, POSIXlt or anything else than can be coerced to a date with \code{as.Date()}. The API will return data on the state of the House of Lords on that date. Defaults to the current system date.}

\item{tidy}{If TRUE, fixes the variable names in the tibble to remove non-alphanumeric characters and superfluous text, and convert to a consistent style. Defaults to TRUE.}

\item{tidy_style}{The style to convert variable names to, if tidy=TRUE. Accepts one of "snake_case", "camelCase" and "period.case". Defaults to "snake_case".}
}
\value{
A tibble with information on the numbers of different types of Lords on a given date.
}
\description{
Calls the API to return a tibble with details on the number of Lords and their affiliations.
}
\examples{
\dontrun{

x <- mnis_lords_type()

}
}
\seealso{
\code{\link{mnis_reference}}
}
\keyword{mnis}
