% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnis_extra.R
\name{mnis_extra}
\alias{mnis_extra}
\title{A wrapper for \code{\link{mnis_additional}} functions.}
\usage{
mnis_extra(ID, ref_dods = FALSE, addresses = TRUE,
  biography_entries = TRUE, committees = TRUE, constituencies = TRUE,
  elections_contested = TRUE, experiences = TRUE, government_posts = TRUE,
  honours = TRUE, house_memberships = TRUE, interests = TRUE,
  known_as = TRUE, maiden_speeches = TRUE, opposition_posts = TRUE,
  other_parliaments = TRUE, parliamentary_posts = TRUE, parties = TRUE,
  preferred_names = TRUE, staff = TRUE, statuses = TRUE, tidy = TRUE,
  tidy_style = "snake_case")
}
\arguments{
\item{ID}{The ID number of the member. Defaults to NULL. If NULL, returns}

\item{ref_dods}{Request based on the DODS membership ID scheme. Defaults to FALSE. If FALSE, requests data based on the default membership ID scheme.}

\item{addresses}{Member address information (e.g. website, twitter, consituency address etc...). Defaults to TRUE. If TRUE, address details are included in the tibble.}

\item{biography_entries}{Member biographical information (e.g. countries of interest, policy expertise etc...) Defaults to TRUE. If TRUE, biographical details are included in the tibble.}

\item{committees}{Committees a Member sits or has sat on as well details on committee chairing. Defaults to TRUE. If TRUE, committee details are included in the tibble.}

\item{constituencies}{constituencies a Member has represented. Defaults to TRUE. If TRUE, constituency details are included in the tibble.}

\item{elections_contested}{Elections a Member has contested but not won. Defaults to TRUE. If TRUE, details of unsuccessful election contests are included in the tibble.}

\item{experiences}{Non-parliamentary experience of a Member. Defaults to TRUE. If TRUE, extra-parliamentary experience details are included in the tibble.}

\item{government_posts}{Government posts a Member currently holds. Defaults to TRUE. If TRUE, government posts details are included in the tibble.}

\item{honours}{Honours (e.g. MBE, OBE etc...) held by a Member. Defaults to TRUE. If TRUE, honours details are included in the tibble.}

\item{house_memberships}{House membership list of a Member. Defaults to TRUE. If TRUE, house membership details are included in the tibble.}

\item{interests}{Registered interests (financial) of a Member. Defaults to TRUE. If TRUE, interest details are included in the tibble.}

\item{known_as}{Details of names a Member has chosen to be known as instead of their full title (House of Lords members only). Defaults to TRUE. If TRUE, known as details are included in the tibble.}

\item{maiden_speeches}{Maiden speech dates for a Member. Defaults to TRUE. If TRUE, maiden speech details are included in the tibble.}

\item{opposition_posts}{Opposition posts a Member has held. Defaults to TRUE. If TRUE, opposition post details are included in the tibble.}

\item{other_parliaments}{Other Parliaments that a Member has held a membership of. Defaults to TRUE. If TRUE, details of other parliaments are included in the tibble.}

\item{parliamentary_posts}{Parliamentary posts a Member has held. Defaults to TRUE. If TRUE, parliamentary posts details are included in the tibble.}

\item{parties}{Party affiliations of a Member. Defaults to TRUE. If TRUE, address details are included in the tibble.}

\item{preferred_names}{Full set of data about a Members' name (e.g. surname, forename, Honorary prefixes, full details of HoL title and rank etc...). Defaults to TRUE. If TRUE, preferred names details are included in the tibble.}

\item{staff}{The staff employed by a Member. Defaults to TRUE. If TRUE, staff details are included in the tibble.}

\item{statuses}{Status history (e.g. suspensions and disqualifications) for a Member. Defaults to TRUE. If TRUE, status details are included in the tibble.}

\item{tidy}{Fix the variable names in the tibble to remove special characters and superfluous text, and converts the variable names to a consistent style. Defaults to TRUE.}

\item{tidy_style}{The style to convert variable names to, if tidy=TRUE. Accepts one of "snake_case", "camelCase" and "period.case". Defaults to "snake_case"}
}
\value{
A tibble with the requested data on a given MP.
}
\description{
It combines the various options of mnis_additional into one dataframe, and the default is similar to \code{\link{mnis_full_biog}}. Variable descriptions are taken from the mnis website: <http://data.parliament.uk/membersdataplatform/memberquery.aspx>.
}
\examples{
\dontrun{

x <- mnis_extra(172)

}
}
\seealso{
\code{\link{mnis_full_biog}} \code{\link{mnis_basic_details}} \code{\link{mnis_additional}}
}
\keyword{mnis}
