% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readdatamlx.R
\name{readDatamlx}
\alias{readDatamlx}
\title{Read formatted data file}
\usage{
readDatamlx(project = NULL, datafile = NULL, header = NULL,
  infoProject = NULL, addl.ss = 10)
}
\arguments{
\item{project}{a Monolix project}

\item{datafile}{a formatted data file}

\item{header}{a vector of strings (mandatory if \code{datafile} is used)}

\item{infoProject}{an xmlfile}

\item{addl.ss}{number of additional doses to use for steady-state  (default=10)}
}
\value{
A list of data frames
}
\description{
Read data in a Monolix/NONMEM format
}
\details{
See http://simulx.webpopix.org/mlxr/readdatamlx/ for more details.
}
\examples{
\dontrun{
d <- readDatamlx(project='monolixRuns/warfarin_project.mlxtran')
names(d)
head(d$treatment)
head(d$covariate)
head(d$y1)

#-- reserved key-words for the header:
#   ID,TIME,AMT,ADM,RATE,TINF,Y,YTYPE,X,COV,CAT,OCC,MDV,EVID,ADDL,SS,II,IGNORE
d <- readDatamlx(datafile='monolixRuns/warfarin_data.txt', 
                 header=c('id','time','amt','y','ytype','cov','cov','cat'))
}
}

