% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{block_size}
\alias{block_size}
\title{Split Raster Into Chunks}
\usage{
block_size(raster, chunksize)
}
\arguments{
\item{raster}{(\link[terra:SpatRaster-class]{terra::SpatRaster})\cr
Raster to be split into chunks.}

\item{chunksize}{(\code{integer(1)})\cr
The chunksize determines in how many subparts the prediction task will be
split into. The value can be roughly thought of as megabyte of a raster file
on disk. For example, if a prediction on a 1 GB file would be carried out
with \code{chunksize = 100L}, the prediction would happen in 10 chunks.

The default of \code{chunksize = 1000L} might be a good compromise between speed
and memory usage. If you find yourself running out of memory, reduce this
value.}
}
\description{
Splits raster into chunks.
}
\keyword{internal}
