% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpPredRegrSurv.R
\name{mlr_pipeops_trafopred_regrsurv}
\alias{mlr_pipeops_trafopred_regrsurv}
\alias{PipeOpPredRegrSurv}
\title{PipeOpPredRegrSurv}
\description{
Transform \link{PredictionRegr} to \link{PredictionSurv}.
}
\section{Input and Output Channels}{

Input and output channels are inherited from \link{PipeOpPredTransformer}.

The output is the input \link{PredictionRegr} transformed to a \link{PredictionSurv}. Censoring can be
added with the \code{status} hyper-parameter. \code{se} is ignored.
}

\section{State}{

The \verb{$state} is a named \code{list} with the \verb{$state} elements inherited from \code{\link{PipeOpPredTransformer}}.
}

\section{Parameters}{

The parameters are
\itemize{
\item \verb{status :: (numeric(1))}\cr
If \code{NULL} then assumed no censoring in the dataset. Otherwise should be a vector of \code{0/1}s
of same length as the prediction object, where \code{1} is dead and \code{0} censored.
}
}

\examples{
\dontrun{
if (requireNamespace("mlr3pipelines", quietly = TRUE)) {
  library(mlr3)
  library(mlr3pipelines)

  # simple example
  pred = PredictionRegr$new(row_ids = 1:10, truth = 1:10, response = 1:10)
  po = po("trafopred_regrsurv")

  # assume no censoring
  new_pred = po$predict(list(pred = pred, task = NULL))[[1]]
  po$train(list(NULL, NULL))
  print(new_pred)

  # add censoring
  task_surv = tsk("rats")
  task_regr = po("trafotask_survregr", method = "omit")$train(list(task_surv, NULL))[[1]]
  learn = lrn("regr.featureless")
  pred = learn$train(task_regr)$predict(task_regr)
  po = po("trafopred_regrsurv")
  new_pred = po$predict(list(pred = pred, task = task_surv))[[1]]
  all.equal(new_pred$truth, task_surv$truth())
}
}
}
\seealso{
Other PipeOps: 
\code{\link{PipeOpPredTransformer}},
\code{\link{PipeOpTaskTransformer}},
\code{\link{PipeOpTransformer}},
\code{\link{mlr_pipeops_survavg}},
\code{\link{mlr_pipeops_trafopred_survregr}},
\code{\link{mlr_pipeops_trafotask_regrsurv}},
\code{\link{mlr_pipeops_trafotask_survregr}}

Other Transformation PipeOps: 
\code{\link{mlr_pipeops_trafopred_survregr}},
\code{\link{mlr_pipeops_trafotask_regrsurv}},
\code{\link{mlr_pipeops_trafotask_survregr}}
}
\concept{PipeOps}
\concept{Transformation PipeOps}
\section{Super classes}{
\code{\link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp}} -> \code{\link[mlr3proba:PipeOpTransformer]{mlr3proba::PipeOpTransformer}} -> \code{\link[mlr3proba:PipeOpPredTransformer]{mlr3proba::PipeOpPredTransformer}} -> \code{PipeOpPredRegrSurv}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{PipeOpPredRegrSurv$new()}}
\item \href{#method-clone}{\code{PipeOpPredRegrSurv$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="predict">}\href{../../mlr3pipelines/html/PipeOp.html#method-predict}{\code{mlr3pipelines::PipeOp$predict()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="print">}\href{../../mlr3pipelines/html/PipeOp.html#method-print}{\code{mlr3pipelines::PipeOp$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="train">}\href{../../mlr3pipelines/html/PipeOp.html#method-train}{\code{mlr3pipelines::PipeOp$train()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpPredRegrSurv$new(id = "trafopred_regrsurv", param_vals = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{character(1)})\cr
Identifier of the resulting  object.}

\item{\code{param_vals}}{(\code{list()})\cr
List of hyperparameter settings, overwriting the hyperparameter settings that would
otherwise be set during construction.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpPredRegrSurv$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
