% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeasureSurvCindex.R
\name{mlr_measures_surv.cindex}
\alias{mlr_measures_surv.cindex}
\alias{MeasureSurvCindex}
\title{Concordance Statistics Survival Measure}
\description{
Calculates weighted concordance statistics, which, depending on the chosen weighting method
and tied times solution, are equivalent to several proposed methods.

For the Kaplan-Meier estimate of the training survival distribution, S, and the Kaplan-Meier
estimate of the training censoring distribution, G:

\code{weight_meth}:
\itemize{
\item \code{"I"} = No weighting. (Harrell)
\item \code{"GH"} = Gonen and Heller's Concordance Index
\item \code{"G"} = Weights concordance by G^-1.
\item \code{"G2"} = Weights concordance by G^-2. (Uno et al.)
\item \code{"SG"} = Weights concordance by S/G (Shemper et al.)
\item \code{"S"} = Weights concordance by S (Peto and Peto)
}

The last three require training data.
}
\section{Dictionary}{

This \link[mlr3:Measure]{Measure} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary}
\link[mlr3:mlr_measures]{mlr_measures} or with the associated sugar function \link[mlr3:mlr_sugar]{msr()}:\preformatted{MeasureSurvCindex$new()
mlr_measures$get("surv.cindex")
msr("surv.cindex")
}
}

\section{Meta Information}{

\itemize{
\item Type: \code{"surv"}
\item Range: \eqn{[0, 1]}{[0, 1]}
\item Minimize: \code{FALSE}
\item Required prediction: \code{crank}
}
}

\references{
Peto, Richard, Peto, Julian (1972).
\dQuote{Asymptotically efficient rank invariant test procedures.}
\emph{Journal of the Royal Statistical Society: Series A (General)}, \bold{135}(2), 185--198.

Harrell, E F, Califf, M R, Pryor, B D, Lee, L K, Rosati, A R (1982).
\dQuote{Evaluating the yield of medical tests.}
\emph{Jama}, \bold{247}(18), 2543--2546.

Gönen M, Heller G (2005).
\dQuote{Concordance probability and discriminatory power in proportional hazards regression.}
\emph{Biometrika}, \bold{92}(4), 965--970.
\doi{10.1093/biomet/92.4.965}.

Schemper, Michael, Wakounig, Samo, Heinze, Georg (2009).
\dQuote{The estimation of average hazard ratios by weighted Cox regression.}
\emph{Statistics in Medicine}, \bold{28}(19), 2473--2489.
\doi{10.1002/sim.3623}, \url{https://doi.org/10.1002/sim.3623}.

Uno H, Cai T, Pencina MJ, D'Agostino RB, Wei LJ (2011).
\dQuote{On the C-statistics for evaluating overall adequacy of risk prediction procedures with censored survival data.}
\emph{Statistics in Medicine}, n/a--n/a.
\doi{10.1002/sim.4154}.
}
\seealso{
Other survival measures: 
\code{\link{mlr_measures_surv.beggC}},
\code{\link{mlr_measures_surv.calib_alpha}},
\code{\link{mlr_measures_surv.calib_beta}},
\code{\link{mlr_measures_surv.chambless_auc}},
\code{\link{mlr_measures_surv.gonenC}},
\code{\link{mlr_measures_surv.grafSE}},
\code{\link{mlr_measures_surv.graf}},
\code{\link{mlr_measures_surv.harrellC}},
\code{\link{mlr_measures_surv.hung_auc}},
\code{\link{mlr_measures_surv.intloglossSE}},
\code{\link{mlr_measures_surv.intlogloss}},
\code{\link{mlr_measures_surv.logloss_se}},
\code{\link{mlr_measures_surv.logloss}},
\code{\link{mlr_measures_surv.maeSE}},
\code{\link{mlr_measures_surv.mae}},
\code{\link{mlr_measures_surv.mseSE}},
\code{\link{mlr_measures_surv.mse}},
\code{\link{mlr_measures_surv.nagelk_r2}},
\code{\link{mlr_measures_surv.oquigley_r2}},
\code{\link{mlr_measures_surv.rmseSE}},
\code{\link{mlr_measures_surv.rmse}},
\code{\link{mlr_measures_surv.schmid}},
\code{\link{mlr_measures_surv.song_auc}},
\code{\link{mlr_measures_surv.song_tnr}},
\code{\link{mlr_measures_surv.song_tpr}},
\code{\link{mlr_measures_surv.unoC}},
\code{\link{mlr_measures_surv.uno_auc}},
\code{\link{mlr_measures_surv.uno_tnr}},
\code{\link{mlr_measures_surv.uno_tpr}},
\code{\link{mlr_measures_surv.xu_r2}}
}
\concept{survival measures}
\section{Super classes}{
\code{\link[mlr3:Measure]{mlr3::Measure}} -> \code{\link[mlr3proba:MeasureSurv]{mlr3proba::MeasureSurv}} -> \code{MeasureSurvCindex}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{cutoff}}{\code{(numeric(1))}
Cut-off time to evaluate concordance up to.}

\item{\code{weight_meth}}{\code{(numeric(1))}
Method for weighting concordance.}

\item{\code{tiex}}{\code{(numeric(1))}
Cut-off time to evaluate concordance up to.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{MeasureSurvCindex$new()}}
\item \href{#method-clone}{\code{MeasureSurvCindex$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="aggregate">}\href{../../mlr3/html/Measure.html#method-aggregate}{\code{mlr3::Measure$aggregate()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="format">}\href{../../mlr3/html/Measure.html#method-format}{\code{mlr3::Measure$format()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="help">}\href{../../mlr3/html/Measure.html#method-help}{\code{mlr3::Measure$help()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="score">}\href{../../mlr3/html/Measure.html#method-score}{\code{mlr3::Measure$score()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3proba" data-topic="MeasureSurv" data-id="print">}\href{../../mlr3proba/html/MeasureSurv.html#method-print}{\code{mlr3proba::MeasureSurv$print()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
This is an abstract class that should not be constructed directly.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MeasureSurvCindex$new(
  cutoff = NULL,
  weight_meth = c("I", "G", "G2", "SG", "S", "GH"),
  tiex = 0.5
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cutoff}}{(\code{numeric(1)})\cr
Cut-off time to evaluate concordance up to.}

\item{\code{weight_meth}}{(\code{character(1)}) \cr
Method for weighting concordance. Default \code{"I"} is Harrell's C. See details.}

\item{\code{tiex}}{(\code{numeric(1)}) \cr
Weighting applied to tied rankings, default is to give them half weighting.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MeasureSurvCindex$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
