% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerSurvRanger.R
\name{LearnerSurvRanger}
\alias{LearnerSurvRanger}
\alias{mlr_learners_surv.ranger}
\title{Ranger Survival Forest Survival Learner}
\format{\code{\link[R6:R6Class]{R6::R6Class()}} inheriting from \link{LearnerSurv}.}
\description{
Calls \code{\link[ranger:ranger]{ranger::ranger()}}.
\itemize{
\item distr is predicted using \code{\link[ranger:predict.ranger]{ranger::predict.ranger()}}
\item \code{crank} is predicted as the expectation of the survival distribution, \code{distr}
}
}
\section{Construction}{
\preformatted{LearnerSurvRanger$new()
mlr_learners$get("surv.ranger")
lrn("surv.ranger")
}
}

\section{Meta Information}{

\itemize{
\item Type: "surv"
\item Predict Types: \verb{distr, crank}
\item Feature Types: \verb{logical, integer, numeric, character, factor, ordered}
\item Packages: \CRANpkg{ranger} \CRANpkg{distr6}
}
}

\references{
Marvin N. Wright and Andreas Ziegler (2017).
ranger: A Fast Implementation of Random Forests for High Dimensional Data in C++ and R.
Journal of Statistical Software, 77(1), 1-17.
\doi{10.18637/jss.v077.i01}.

Breiman, L. (2001).
Random Forests.
Machine Learning 45(1).
\doi{10.1023/A:1010933404324}.
}
\seealso{
Other survival learners: 
\code{\link{LearnerSurvBlackboost}},
\code{\link{LearnerSurvCVGlmnet}},
\code{\link{LearnerSurvCoxPH}},
\code{\link{LearnerSurvFlexible}},
\code{\link{LearnerSurvGBM}},
\code{\link{LearnerSurvGamboost}},
\code{\link{LearnerSurvGlmboost}},
\code{\link{LearnerSurvGlmnet}},
\code{\link{LearnerSurvKaplan}},
\code{\link{LearnerSurvMboost}},
\code{\link{LearnerSurvNelson}},
\code{\link{LearnerSurvParametric}},
\code{\link{LearnerSurvPenalized}},
\code{\link{LearnerSurvRandomForestSRC}},
\code{\link{LearnerSurvRpart}},
\code{\link{LearnerSurvSVM}}
}
\concept{survival learners}
