% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crate.R
\name{crate}
\alias{crate}
\title{Isolate a Function from its Environment}
\usage{
crate(.fn, ..., .parent = topenv(parent.frame()), .compile = TRUE)
}
\arguments{
\item{.fn}{(\verb{function()})\cr
function to crate}

\item{...}{(\code{any})\cr
The objects, which should be visible inside \code{.fn}.}

\item{.parent}{(\code{environment})\cr
Parent environment to look up names. Default to \code{\link[=topenv]{topenv()}}.}

\item{.compile}{(\code{logical(1)})\cr
Whether to jit-compile the function.
In case the function is already compiled.
If the input function \code{.fn} is compiled, this has no effect, and the output function will always be compiled.}
}
\description{
Put a function in a "lean" environment that does not carry unnecessary baggage with it (e.g. references to datasets).
}
\examples{
meta_f = function(z) {
  x = 1
  y = 2
  crate(function() {
    c(x, y, z)
  }, x)
}
x = 100
y = 200
z = 300
f = meta_f(1)
f()
}
