% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_factor.R
\name{as_factor}
\alias{as_factor}
\title{Convert to Factor}
\usage{
as_factor(x, levels, ordered = is.ordered(x))
}
\arguments{
\item{x}{:: atomic \code{vector()}\cr
Vector to convert to factor.}

\item{levels}{:: \code{character()}\cr
Levels of the new factor.}

\item{ordered}{:: \code{logical(1)}\cr
If \code{TRUE}, create an ordered factor.}
}
\value{
(\code{factor()}).
}
\description{
Converts a vector to a \code{\link[=factor]{factor()}} and ensures that levels are
in the order of the provided levels.
}
\examples{
x = factor(c("a", "b"))
y = factor(c("a", "b"), levels = c("b", "a"))

# x with the level order of y
as_factor(x, levels(y))

# y with the level order of x
as_factor(y, levels(x))
}
