% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FSelectorAsync.R
\name{FSelectorAsync}
\alias{FSelectorAsync}
\title{Class for Asynchronous Feature Selection Algorithms}
\description{
The \link{FSelectorAsync} implements the asynchronous optimization algorithm.
}
\details{
\link{FSelectorAsync} is an abstract base class that implements the base functionality each asynchronous fselector must provide.
}
\section{Resources}{

There are several sections about feature selection in the \href{https://mlr3book.mlr-org.com}{mlr3book}.
\itemize{
\item Learn more about \href{https://mlr3book.mlr-org.com/chapters/chapter6/feature_selection.html#the-fselector-class}{fselectors}.
}

The \href{https://mlr-org.com/gallery.html}{gallery} features a collection of case studies and demos about optimization.
\itemize{
\item Utilize the built-in feature importance of models with \href{https://mlr-org.com/gallery/optimization/2023-02-07-recursive-feature-elimination/}{Recursive Feature Elimination}.
\item Run a feature selection with \href{https://mlr-org.com/gallery/optimization/2023-02-01-shadow-variable-search/}{Shadow Variable Search}.
}
}

\section{Super class}{
\code{\link[mlr3fselect:FSelector]{mlr3fselect::FSelector}} -> \code{FSelectorAsync}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FSelectorAsync-optimize}{\code{FSelectorAsync$optimize()}}
\item \href{#method-FSelectorAsync-clone}{\code{FSelectorAsync$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3fselect" data-topic="FSelector" data-id="format"><a href='../../mlr3fselect/html/FSelector.html#method-FSelector-format'><code>mlr3fselect::FSelector$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3fselect" data-topic="FSelector" data-id="help"><a href='../../mlr3fselect/html/FSelector.html#method-FSelector-help'><code>mlr3fselect::FSelector$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3fselect" data-topic="FSelector" data-id="initialize"><a href='../../mlr3fselect/html/FSelector.html#method-FSelector-initialize'><code>mlr3fselect::FSelector$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3fselect" data-topic="FSelector" data-id="print"><a href='../../mlr3fselect/html/FSelector.html#method-FSelector-print'><code>mlr3fselect::FSelector$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FSelectorAsync-optimize"></a>}}
\if{latex}{\out{\hypertarget{method-FSelectorAsync-optimize}{}}}
\subsection{Method \code{optimize()}}{
Performs the feature selection on a \link{FSelectInstanceAsyncSingleCrit} or \link{FSelectInstanceAsyncMultiCrit} until termination.
The single evaluations will be written into the \link{ArchiveAsyncFSelect} that resides in the \link{FSelectInstanceAsyncSingleCrit}/\link{FSelectInstanceAsyncMultiCrit}.
The result will be written into the instance object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FSelectorAsync$optimize(inst)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{inst}}{(\link{FSelectInstanceAsyncSingleCrit} | \link{FSelectInstanceAsyncMultiCrit}).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link[data.table:data.table]{data.table::data.table()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FSelectorAsync-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FSelectorAsync-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FSelectorAsync$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
