% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FSelectorShadowVariableSearch.R
\name{mlr_fselectors_shadow_variable_search}
\alias{mlr_fselectors_shadow_variable_search}
\alias{FSelectorShadowVariableSearch}
\title{Feature Selection with Shadow Variable Search}
\source{
Thomas J, Hepp T, Mayr A, Bischl B (2017).
\dQuote{Probing for Sparse and Fast Variable Selection with Model-Based Boosting.}
\emph{Computational and Mathematical Methods in Medicine}, \bold{2017}, 1--8.
\doi{10.1155/2017/1421409}.

Wu Y, Boos DD, Stefanski LA (2007).
\dQuote{Controlling Variable Selection by the Addition of Pseudovariables.}
\emph{Journal of the American Statistical Association}, \bold{102}(477), 235--243.
\doi{10.1198/016214506000000843}.
}
\description{
Feature selection using the Shadow Variable Search Algorithm.
Shadow variable search creates for each feature a permutated copy and stops when one of them is selected.
}
\details{
The feature selection terminates itself when the first shadow variable is selected.
It is not necessary to set a termination criterion.
}
\section{Resources}{

The \href{https://mlr-org.com/gallery.html}{gallery} features a collection of case studies and demos about optimization.
\itemize{
\item Run a feature selection with \href{https://mlr-org.com/gallery/optimization/2023-02-01-shadow-variable-search/}{Shadow Variable Search}.
}
}

\section{Dictionary}{

This \link{FSelector} can be instantiated with the associated sugar function \code{\link[=fs]{fs()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{fs("shadow_variable_search")
}\if{html}{\out{</div>}}
}

\examples{
# Feature Selection
\donttest{

# retrieve task and load learner
task = tsk("penguins")
learner = lrn("classif.rpart")

# run feature selection on the Palmer Penguins data set
instance = fselect(
  fselector = fs("shadow_variable_search"),
  task = task,
  learner = learner,
  resampling = rsmp("holdout"),
  measure = msr("classif.ce"),
)

# best performing feature subset
instance$result

# all evaluated feature subsets
as.data.table(instance$archive)

# subset the task and fit the final model
task$select(instance$result_feature_set)
learner$train(task)
}
}
\seealso{
Other FSelector: 
\code{\link{mlr_fselectors}},
\code{\link{mlr_fselectors_design_points}},
\code{\link{mlr_fselectors_exhaustive_search}},
\code{\link{mlr_fselectors_genetic_search}},
\code{\link{mlr_fselectors_random_search}},
\code{\link{mlr_fselectors_rfe}},
\code{\link{mlr_fselectors_rfecv}},
\code{\link{mlr_fselectors_sequential}}
}
\concept{FSelector}
\section{Super class}{
\code{\link[mlr3fselect:FSelector]{mlr3fselect::FSelector}} -> \code{FSelectorShadowVariableSearch}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FSelectorShadowVariableSearch-new}{\code{FSelectorShadowVariableSearch$new()}}
\item \href{#method-FSelectorShadowVariableSearch-optimization_path}{\code{FSelectorShadowVariableSearch$optimization_path()}}
\item \href{#method-FSelectorShadowVariableSearch-clone}{\code{FSelectorShadowVariableSearch$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3fselect" data-topic="FSelector" data-id="format"><a href='../../mlr3fselect/html/FSelector.html#method-FSelector-format'><code>mlr3fselect::FSelector$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3fselect" data-topic="FSelector" data-id="help"><a href='../../mlr3fselect/html/FSelector.html#method-FSelector-help'><code>mlr3fselect::FSelector$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3fselect" data-topic="FSelector" data-id="optimize"><a href='../../mlr3fselect/html/FSelector.html#method-FSelector-optimize'><code>mlr3fselect::FSelector$optimize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3fselect" data-topic="FSelector" data-id="print"><a href='../../mlr3fselect/html/FSelector.html#method-FSelector-print'><code>mlr3fselect::FSelector$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FSelectorShadowVariableSearch-new"></a>}}
\if{latex}{\out{\hypertarget{method-FSelectorShadowVariableSearch-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.`
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FSelectorShadowVariableSearch$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FSelectorShadowVariableSearch-optimization_path"></a>}}
\if{latex}{\out{\hypertarget{method-FSelectorShadowVariableSearch-optimization_path}{}}}
\subsection{Method \code{optimization_path()}}{
Returns the optimization path.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FSelectorShadowVariableSearch$optimization_path(inst)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{inst}}{(\link{FSelectInstanceSingleCrit})\cr
Instance optimized with \link{FSelectorShadowVariableSearch}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link[data.table:data.table]{data.table::data.table}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FSelectorShadowVariableSearch-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FSelectorShadowVariableSearch-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FSelectorShadowVariableSearch$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
