% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/warn_deprecated.R
\name{warn_deprecated}
\alias{warn_deprecated}
\title{Give a Warning about a Deprecated Function, Argument, or Active Binding}
\usage{
warn_deprecated(what)
}
\arguments{
\item{what}{(character(1))\cr
A description of the deprecated entity. This should be somewhat descriptive,
e.g. \code{"Class$method()"} or \code{"Argument 'foo' of Class$method()"}.\cr
The \code{what} is used to determine if the warning has already been given, so
it should be unique for each deprecated entity.}
}
\description{
Generates a warning when a deprecated function, argument, or active binding
is used or accessed. A warning will only be given once per session, and all
deprecation warnings can be suppressed by setting the option
\code{mlr3.warn_deprecated = FALSE}.

The warning is of the format
"what is deprecated and will be removed in the future."

Use the 'deprecated_binding()' helper function to create an active binding
that generates a warning when accessed.
}
\keyword{internal}
