% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateBenchmarkSummary.R
\name{plotBenchmarkSummary}
\alias{plotBenchmarkSummary}
\title{Plot a benchmark-summary.}
\usage{
plotBenchmarkSummary(obj)
}
\arguments{
\item{obj}{[\code{BenchmarkSummaryData}]\cr
Output of a \link{generateBenchmarkSummaryData} function.}
}
\value{
ggplot2 plot object.
}
\description{
Plots a BenchmarkSummaryPlot for a selected \link{Measure}.
Full tiles correspond
to the worst performance accross all \code{tasks}
and \code{learner}. The actuall fill
corresponds to the proportional performance of the \dQuote{best}
or \dQuote{worst} within the task. Sorting along the x-axis is done
accoriding to the algorithms rank.
}
\examples{
lrns = list(makeLearner("classif.nnet"), makeLearner("classif.rpart"))
tasks = list(iris.task, sonar.task)
rdesc = makeResampleDesc("CV", iters = 2L)
meas = list(acc, mmce, ber, timeboth)
res = benchmark(lrns, tasks, rdesc, meas)
g = generateBenchmarkSummaryData(res, ber, fill = "best")
plotBenchmarkSummary(g)

}
\references{
This plot is analogous to the one described in: \cr
Manuel J. A. Eugster, Torsten Hothorn and Friedrich Leisch;
Domain-Based Benchmark Experiments:Exploratory and Inferential Analysis,
AUSTRIAN JOURNAL OF STATISTICS Volume 41 (2012), Number 1
but does not include any clustering or sorting.
}
\seealso{
Other benchmark: \code{\link{BenchmarkResult}},
  \code{\link{benchmark}},
  \code{\link{convertBMRToRankMatrix}},
  \code{\link{friedmanPostHocTestBMR}},
  \code{\link{friedmanTestBMR}},
  \code{\link{generateBenchmarkSummaryData}},
  \code{\link{generateCritDifferencesData}},
  \code{\link{generateRankMatrixAsBarData}},
  \code{\link{getBMRAggrPerformances}},
  \code{\link{getBMRFeatSelResults}},
  \code{\link{getBMRFilteredFeatures}},
  \code{\link{getBMRLearnerIds}},
  \code{\link{getBMRLearners}},
  \code{\link{getBMRMeasureIds}},
  \code{\link{getBMRMeasures}},
  \code{\link{getBMRPerformances}},
  \code{\link{getBMRPredictions}},
  \code{\link{getBMRTaskIds}},
  \code{\link{getBMRTuneResults}},
  \code{\link{plotBenchmarkResult}},
  \code{\link{plotCritDifferences}},
  \code{\link{plotRankMatrixAsBar}}

Other plot: \code{\link{plotBenchmarkResult}},
  \code{\link{plotCalibration}},
  \code{\link{plotCritDifferences}},
  \code{\link{plotFilterValuesGGVIS}},
  \code{\link{plotFilterValues}},
  \code{\link{plotLearningCurveGGVIS}},
  \code{\link{plotLearningCurve}},
  \code{\link{plotPartialPredictionGGVIS}},
  \code{\link{plotPartialPrediction}},
  \code{\link{plotROCCurves}},
  \code{\link{plotROCRCurvesGGVIS}},
  \code{\link{plotROCRCurves}},
  \code{\link{plotRankMatrixAsBar}},
  \code{\link{plotThreshVsPerfGGVIS}},
  \code{\link{plotThreshVsPerf}}
}

