% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateRankMatrixAsBar.R
\name{generateRankMatrixAsBarData}
\alias{generateRankMatrixAsBarData}
\title{Generate data to plot a rank-matrix as a barplot.}
\usage{
generateRankMatrixAsBarData(bmr, measure = NULL, pos = "tile",
  order.lrns = NULL, order.tsks = NULL)
}
\arguments{
\item{bmr}{[\code{\link{BenchmarkResult}}]\cr
Benchmark result.}

\item{measure}{[\code{\link{Measure}}]\cr
Performance measure.
Default is the default measure for the task, see here \code{\link{getDefaultMeasure}}.}

\item{pos}{[\code{character(1)}]
Optionally set how the bars are positioned in \code{\link{ggplot2}}. \cr
Ranks are plotted on the x-axis. \cr
\dQuote{tile} plots a heatmap with \code{tasks} as the y-axis.\cr
Allows identification of the performance in a special task.\cr
\dQuote{stack} plots a stacked barplot. \cr
Allows for comparison of learners within and and accross ranks.\cr
\dQuote{dodge} plots a barplot with bars next to each other instead
of stacked bars.\cr}

\item{order.lrns}{[\code{character(n.learners)}]\cr 
Character vector with \code{learner.ids} in new order.}

\item{order.tsks}{[\code{character(n.tasks)}] \cr 
Character vector with \code{task.ids} in new order.}
}
\value{
[\code{RankMatrixAsBarData}]. List with items:
\item{data}{\code{data.frame} containing the data for plotting}
\item{measure}{measure the ranks are calculated on}
\item{pos}{Positioning info for the plot}
}
\description{
Generate Data for \code{\link{plotRankMatrixAsBar}}.
Ties in ranks are broken randomly, in order to assert non-overlapping
and non-empty bars.
}
\examples{
# see plotRankMatrixAsBar
}
\seealso{
Other benchmark: \code{\link{BenchmarkResult}},
  \code{\link{benchmark}},
  \code{\link{convertBMRToRankMatrix}},
  \code{\link{friedmanPostHocTestBMR}},
  \code{\link{friedmanTestBMR}},
  \code{\link{generateBenchmarkSummaryData}},
  \code{\link{generateCritDifferencesData}},
  \code{\link{getBMRAggrPerformances}},
  \code{\link{getBMRFeatSelResults}},
  \code{\link{getBMRFilteredFeatures}},
  \code{\link{getBMRLearnerIds}},
  \code{\link{getBMRLearners}},
  \code{\link{getBMRMeasureIds}},
  \code{\link{getBMRMeasures}},
  \code{\link{getBMRPerformances}},
  \code{\link{getBMRPredictions}},
  \code{\link{getBMRTaskIds}},
  \code{\link{getBMRTuneResults}},
  \code{\link{plotBenchmarkResult}},
  \code{\link{plotBenchmarkSummary}},
  \code{\link{plotCritDifferences}},
  \code{\link{plotRankMatrixAsBar}}

Other generate_plot_data: \code{\link{generateBenchmarkSummaryData}},
  \code{\link{generateCalibrationData}},
  \code{\link{generateCritDifferencesData}},
  \code{\link{generateFilterValuesData}},
  \code{\link{generateLearningCurveData}},
  \code{\link{generatePartialPredictionData}},
  \code{\link{generateROCRCurvesData}},
  \code{\link{generateThreshVsPerfData}},
  \code{\link{getFilterValues}}
}

