% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ModelMultiplexerParamSet.R
\name{makeModelMultiplexerParamSet}
\alias{makeModelMultiplexerParamSet}
\title{Creates a parameter set for model multiplexer tuning.}
\usage{
makeModelMultiplexerParamSet(multiplexer, ..., .check = TRUE)
}
\arguments{
\item{multiplexer}{[\code{\link{ModelMultiplexer}}]\cr
The muliplexer learner.}

\item{...}{[\code{\link[ParamHelpers]{ParamSet}} | \code{\link[ParamHelpers]{Param}}]\cr
(a) First option: Named param sets. Names must correspond to base learners.
You only need to enter the parameters you want to tune without reference
to the \code{selected.learner} field in any way.\cr
(b) Second option. Just the params you would enter in the param sets.
Even shorterto create. Only works when it can be uniquely identified to which
learner each of your passed parameters belongs.}

\item{.check}{[\code{logical}]\cr
Check that for each param in \code{...} one param in found in the base learners.
Default is \code{TRUE}}
}
\value{
[\code{\link[ParamHelpers]{ParamSet}}].
}
\description{
Handy way to create the param set with less typing.

The following is done automatically:
\itemize{
\item{The \code{selected.learner} param is created}
\item{Parameter names are prefixed.}
\item{The \code{requires} field of each param is set.
  This makes all parameters subordinate to \code{selected.learner}}
}
}
\examples{
# See makeModelMultiplexer
}
\seealso{
Other multiplexer: \code{\link{ModelMultiplexer}},
  \code{\link{makeModelMultiplexer}}

Other tune: \code{\link{ModelMultiplexer}},
  \code{\link{makeModelMultiplexer}};
  \code{\link{TuneControl}},
  \code{\link{TuneControlCMAES}},
  \code{\link{TuneControlGenSA}},
  \code{\link{TuneControlGrid}},
  \code{\link{TuneControlIrace}},
  \code{\link{TuneControlRandom}},
  \code{\link{makeTuneControlCMAES}},
  \code{\link{makeTuneControlDesign}},
  \code{\link{makeTuneControlGenSA}},
  \code{\link{makeTuneControlGrid}},
  \code{\link{makeTuneControlIrace}},
  \code{\link{makeTuneControlRandom}};
  \code{\link{getNestedTuneResultsOptPathDf}};
  \code{\link{getNestedTuneResultsX}};
  \code{\link{getTuneResult}};
  \code{\link{makeTuneWrapper}}; \code{\link{tuneParams}};
  \code{\link{tuneThreshold}}
}

